/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLineEdit;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QWidget;

public class EnCryptDialog
extends QDialog {
    private boolean okPressed = false;
    private final QLineEdit password;
    private final QLineEdit password2;
    private final QLineEdit hint;
    private final QPushButton ok;
    private final QLabel error;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");

    public EnCryptDialog() {
        this.setWindowTitle(this.tr("Encrypt Text"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "password.png"));
        QGridLayout grid = new QGridLayout();
        QGridLayout input = new QGridLayout();
        QGridLayout msgGrid = new QGridLayout();
        QGridLayout button = new QGridLayout();
        this.setLayout((QLayout)grid);
        this.hint = new QLineEdit("");
        this.password = new QLineEdit("");
        this.password.setEchoMode(QLineEdit.EchoMode.Password);
        this.password2 = new QLineEdit("");
        this.password2.setEchoMode(QLineEdit.EchoMode.Password);
        input.addWidget((QWidget)new QLabel(this.tr("Password")), 1, 1);
        input.addWidget((QWidget)this.password, 1, 2);
        input.addWidget((QWidget)new QLabel(this.tr("Verify")), 2, 1);
        input.addWidget((QWidget)this.password2, 2, 2);
        input.addWidget((QWidget)new QLabel(this.tr("Hint")), 3, 1);
        input.addWidget((QWidget)this.hint, 3, 2);
        input.setContentsMargins(10, 10, -10, -10);
        grid.addLayout((QLayout)input, 1, 1);
        this.error = new QLabel();
        msgGrid.addWidget((QWidget)this.error, 1, 1);
        grid.addLayout((QLayout)msgGrid, 2, 1);
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okButtonPressed()");
        this.ok.setEnabled(false);
        QPushButton cancel = new QPushButton(this.tr("Cancel"));
        cancel.clicked.connect((Object)this, "cancelButtonPressed()");
        button.addWidget((QWidget)this.ok, 1, 1);
        button.addWidget((QWidget)cancel, 1, 2);
        grid.addLayout((QLayout)button, 3, 1);
        this.password.textChanged.connect((Object)this, "validateInput()");
        this.password2.textChanged.connect((Object)this, "validateInput()");
        this.hint.textChanged.connect((Object)this, "validateInput()");
    }

    private void okButtonPressed() {
        this.okPressed = true;
        this.close();
    }

    private void cancelButtonPressed() {
        this.okPressed = false;
        this.close();
    }

    public String getPasswordVerify() {
        return this.password2.text();
    }

    public String getPassword() {
        return this.password.text();
    }

    public String getHint() {
        return this.hint.text();
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    private void validateInput() {
        this.ok.setEnabled(false);
        this.error.setText("");
        if (this.password.text().length() < 4) {
            this.error.setText(this.tr("Password must be at least 4 characters"));
            return;
        }
        if (!this.password.text().equals(this.password2.text())) {
            this.error.setText(this.tr("Passwords do not match"));
            return;
        }
        if (this.hint.text().trim().equals("")) {
            this.error.setText(this.tr("Hint must be entered"));
            return;
        }
        this.ok.setEnabled(true);
    }
}

