/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.designer;

import com.trolltech.qt.designer.ColorPropertyHandler;
import com.trolltech.qt.designer.PropertyHandler;
import com.trolltech.qt.designer.QUiLoaderException;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QBrush;
import com.trolltech.qt.gui.QColor;
import com.trolltech.qt.gui.QPalette;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNode;
import com.trolltech.qt.xml.QDomNodeList;
import java.util.HashMap;

class PalettePropertyHandler
extends PropertyHandler {
    private ColorPropertyHandler colorHandler = new ColorPropertyHandler();
    static HashMap<String, QPalette.ColorRole> colorRoles = new HashMap();

    PalettePropertyHandler() {
    }

    public Object create(QDomElement e) throws QUiLoaderException {
        QPalette p = QApplication.palette();
        this.parse(e.namedItem("active").toElement(), p, QPalette.ColorGroup.Active);
        this.parse(e.namedItem("inactive").toElement(), p, QPalette.ColorGroup.Inactive);
        this.parse(e.namedItem("disabled").toElement(), p, QPalette.ColorGroup.Disabled);
        return p;
    }

    private void parse(QDomElement groupElement, QPalette p, QPalette.ColorGroup group) throws QUiLoaderException {
        QDomNodeList list = groupElement.childNodes();
        for (int i = 0; i < list.count(); ++i) {
            QDomNode node = list.at(i);
            if (!node.nodeName().equals("colorrole")) continue;
            QDomElement roleElement = node.toElement();
            QPalette.ColorRole role = colorRoles.get(roleElement.attribute("role"));
            QDomElement brushElement = roleElement.namedItem("brush").toElement();
            if (!brushElement.attribute("brushstyle").equals("SolidPattern")) {
                throw new QUiLoaderException("Unhandled brush style: " + brushElement.attribute("brushstyle"));
            }
            QColor color = (QColor)this.colorHandler.create(brushElement.namedItem("color").toElement());
            QBrush brush = new QBrush(color);
            p.setBrush(group, role, brush);
        }
    }

    static {
        for (QPalette.ColorRole role : QPalette.ColorRole.values()) {
            colorRoles.put(role.name(), role);
        }
    }
}

