/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.dialog;

import com.evernote.edam.type.Note;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QTemporaryFile;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QDialog;
import com.trolltech.qt.gui.QHBoxLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QPushButton;
import com.trolltech.qt.gui.QVBoxLayout;
import com.trolltech.qt.gui.QWidget;
import cx.fbn.nevernote.clipboard.ClipBoardObserver;
import cx.fbn.nevernote.gui.BrowserWindow;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.Pair;
import cx.fbn.nevernote.xml.NoteFormatter;
import java.util.List;

public class NoteQuickLinkDialog
extends QDialog {
    public final QPushButton ok;
    public final QPushButton cancel;
    private final DatabaseConnection conn;
    public final QComboBox titleCombo;
    private final BrowserWindow browser;
    private final ApplicationLogger logger;
    List<Pair<String, String>> results;
    public boolean okPressed = false;
    private List<QTemporaryFile> tempFiles;
    private final String iconPath = new String("classpath:cx/fbn/nevernote/icons/");
    private final ClipBoardObserver cbObserver;

    public NoteQuickLinkDialog(ApplicationLogger l, DatabaseConnection c, String text, ClipBoardObserver cbObserver) {
        this.setWindowTitle(this.tr("Quick Link Notes"));
        this.setWindowIcon(new QIcon(String.valueOf(this.iconPath) + "notebook-green.png"));
        QVBoxLayout main = new QVBoxLayout();
        this.setLayout((QLayout)main);
        this.titleCombo = new QComboBox((QWidget)this);
        QHBoxLayout comboLayout = new QHBoxLayout();
        comboLayout.addWidget((QWidget)new QLabel(this.tr("Matching Notes:")));
        comboLayout.addWidget((QWidget)this.titleCombo);
        comboLayout.addStretch(100);
        main.addLayout((QLayout)comboLayout);
        this.conn = c;
        this.cbObserver = cbObserver;
        this.browser = new BrowserWindow(this.conn, this.cbObserver);
        main.addWidget((QWidget)this.browser);
        this.browser.titleLabel.setVisible(false);
        this.browser.notebookBox.setVisible(false);
        this.browser.hideButtons();
        this.browser.tagEdit.setVisible(false);
        this.browser.tagLabel.setVisible(false);
        QHBoxLayout buttonLayout = new QHBoxLayout();
        buttonLayout.addStretch(100);
        this.ok = new QPushButton(this.tr("OK"));
        this.ok.clicked.connect((Object)this, "okPressed()");
        this.cancel = new QPushButton(this.tr("Cancel"));
        this.cancel.clicked.connect((Object)this, "cancelPressed()");
        buttonLayout.addWidget((QWidget)this.ok);
        buttonLayout.addWidget((QWidget)this.cancel);
        main.addLayout((QLayout)buttonLayout);
        this.browser.getBrowser().setContextMenuPolicy(Qt.ContextMenuPolicy.NoContextMenu);
        this.logger = l;
        this.results = this.conn.getNoteTable().findNotesByTitle(text);
        int i = 0;
        while (i < this.results.size()) {
            this.titleCombo.addItem(this.results.get(i).getSecond(), (Object)this.results.get(i).getFirst());
            ++i;
        }
        this.titleCombo.activated.connect((Object)this, "selectionChanged(String)");
        if (this.results.size() > 0) {
            Note currentNote = this.conn.getNoteTable().getNote(this.results.get(0).getFirst(), true, true, false, true, true);
            this.setContent(currentNote);
        }
    }

    private void cancelPressed() {
        this.close();
    }

    private void okPressed() {
        this.okPressed = true;
        this.close();
    }

    private void selectionChanged(String text) {
        int pos = this.titleCombo.currentIndex();
        String guid = this.results.get(pos).getFirst();
        Note note = this.conn.getNoteTable().getNote(guid, true, true, false, true, true);
        this.setContent(note);
    }

    public String getSelectedNote() {
        int pos = this.titleCombo.currentIndex();
        return this.results.get(pos).getFirst();
    }

    public void setContent(Note currentNote) {
        NoteFormatter formatter = new NoteFormatter(this.logger, this.conn, this.tempFiles);
        formatter.setNote(currentNote, false);
        formatter.setHighlight(null);
        formatter.setNoteHistory(true);
        StringBuffer js = new StringBuffer();
        js.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        js.append("<style type=\"text/css\">en-crypt-temp { border-style:solid; border-color:blue; padding:1mm 1mm 1mm 1mm; }</style>");
        js.append("</head>");
        js.append(formatter.rebuildNoteHTML());
        js.append("</HTML>");
        this.browser.setNote(currentNote);
        this.browser.setContent(new QByteArray(js.toString()));
    }

    public List<Pair<String, String>> getResults() {
        return this.results;
    }
}

