/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class AddMessageToEachPage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String file, String message, String outfile) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load(file);
            List allPages = doc.getDocumentCatalog().getAllPages();
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            float fontSize = 36.0f;
            for (int i = 0; i < allPages.size(); ++i) {
                PDPage page = (PDPage)allPages.get(i);
                PDRectangle pageSize = page.findMediaBox();
                float stringWidth = font.getStringWidth(message) * fontSize / 1000.0f;
                int rotation = page.findRotation();
                boolean rotate = rotation == 90 || rotation == 270;
                float pageWidth = rotate ? pageSize.getHeight() : pageSize.getWidth();
                float pageHeight = rotate ? pageSize.getWidth() : pageSize.getHeight();
                double centeredXPosition = rotate ? (double)(pageHeight / 2.0f) : (double)((pageWidth - stringWidth) / 2.0f);
                double centeredYPosition = rotate ? (double)((pageWidth - stringWidth) / 2.0f) : (double)(pageHeight / 2.0f);
                PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true, true);
                contentStream.beginText();
                contentStream.setFont(font, fontSize);
                contentStream.setNonStrokingColor(255, 0, 0);
                if (rotate) {
                    contentStream.setTextRotation(1.5707963267948966, centeredXPosition, centeredYPosition);
                } else {
                    contentStream.setTextTranslation(centeredXPosition, centeredYPosition);
                }
                contentStream.drawString(message);
                contentStream.endText();
                contentStream.close();
            }
            doc.save(outfile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        AddMessageToEachPage app = new AddMessageToEachPage();
        try {
            if (args.length != 3) {
                app.usage();
            } else {
                app.doIt(args[0], args[1], args[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file> <Message> <output-file>");
    }
}

