/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import com.evernote.edam.type.Tag;
import com.trolltech.qt.core.QBuffer;
import com.trolltech.qt.core.QByteArray;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QImage;
import com.trolltech.qt.gui.QPixmap;
import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedTable;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TagTable {
    private final ApplicationLogger logger;
    DatabaseConnection db;

    public TagTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table Tag...");
        if (!query.exec("Create table Tag (guid varchar primary key, parentGuid varchar, sequence integer, hashCode integer, name varchar, isDirty boolean)")) {
            this.logger.log(this.logger.HIGH, "Table TAG creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table Tag");
    }

    public List<Tag> getTagsForNotebook(String notebookGuid) {
        ArrayList<Tag> index = new ArrayList<Tag>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Select guid, parentGuid, sequence, name from Tag where notebookGuid=:notebookGuid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Tag SQL prepare getTagsForNotebook has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError());
        }
        query.bindValue(":notebookGuid", notebookGuid);
        query.exec();
        while (query.next()) {
            Tag tempTag = new Tag();
            tempTag.setGuid(query.valueString(0));
            if (query.valueString(1) != null) {
                tempTag.setParentGuid(query.valueString(1));
            } else {
                tempTag.setParentGuid(null);
            }
            int sequence = new Integer(query.valueString(2));
            tempTag.setUpdateSequenceNum(sequence);
            tempTag.setName(query.valueString(3));
            index.add(tempTag);
        }
        return index;
    }

    public List<Tag> getAll() {
        ArrayList<Tag> index = new ArrayList<Tag>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, parentGuid, sequence, name from Tag where notebookguid not in (select guid from notebook where archived=true)");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Tag SQL retrieve has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError());
        }
        while (query.next()) {
            Tag tempTag = new Tag();
            tempTag.setGuid(query.valueString(0));
            if (query.valueString(1) != null) {
                tempTag.setParentGuid(query.valueString(1));
            } else {
                tempTag.setParentGuid(null);
            }
            int sequence = new Integer(query.valueString(2));
            tempTag.setUpdateSequenceNum(sequence);
            tempTag.setName(query.valueString(3));
            index.add(tempTag);
        }
        return index;
    }

    public Tag getTag(String guid) {
        Tag tempTag = new Tag();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select guid, parentGuid, sequence, name from Tag where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Tag select by guid SQL prepare has failed.");
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Tag select by guid SQL exec has failed.");
        }
        if (!query.next()) {
            return tempTag;
        }
        tempTag.setGuid(query.valueString(0));
        tempTag.setParentGuid(query.valueString(1));
        int sequence = new Integer(query.valueString(2));
        tempTag.setUpdateSequenceNum(sequence);
        tempTag.setName(query.valueString(3));
        return tempTag;
    }

    public void updateTag(Tag tempTag, boolean isDirty) {
        this.updateTag(tempTag, isDirty, "");
    }

    public void updateTag(Tag tempTag, boolean isDirty, String realName) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Tag set parentGuid=:parentGuid, sequence=:sequence, hashCode=:hashCode, name=:name, isDirty=:isDirty where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Tag SQL update prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError());
        }
        query.bindValue(":parentGuid", tempTag.getParentGuid());
        query.bindValue(":sequence", tempTag.getUpdateSequenceNum());
        query.bindValue(":hashCode", tempTag.hashCode());
        query.bindValue(":name", tempTag.getName());
        query.bindValue(":isDirty", isDirty);
        query.bindValue(":guid", tempTag.getGuid());
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag Table update failed.");
        }
    }

    public void expungeTag(String guid, boolean needsSync) {
        Tag t = this.getTag(guid);
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("delete from Tag where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Tag SQL delete prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError());
        }
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag delete failed.");
        }
        if (!(check = query.prepare("delete from NoteTags where tagGuid=:guid"))) {
            this.logger.log(this.logger.EXTREME, "NoteTags SQL delete prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError());
        }
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "NoteTags delete failed.");
        }
        if (needsSync && t != null && t.getUpdateSequenceNum() > 0) {
            DeletedTable del = new DeletedTable(this.logger, this.db);
            del.addDeletedItem(guid, "Tag");
        }
    }

    public void addTag(Tag tempTag, boolean isDirty) {
        this.addTag(tempTag, isDirty, false, "", "");
    }

    public void addTag(Tag tempTag, boolean isDirty, boolean isLinked, String realName, String notebookGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Insert Into Tag (guid, parentGuid, sequence, hashCode, name, isDirty, linked, realName, notebookGuid) Values(:guid, :parentGuid, :sequence, :hashCode, :name, :isDirty, :linked, :realName, :notebookGuid)");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Tag SQL insert prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError());
        }
        query.bindValue(":guid", tempTag.getGuid());
        query.bindValue(":parentGuid", tempTag.getParentGuid());
        query.bindValue(":sequence", tempTag.getUpdateSequenceNum());
        query.bindValue(":hashCode", tempTag.hashCode());
        query.bindValue(":name", tempTag.getName());
        query.bindValue(":isDirty", isDirty);
        query.bindValue(":linked", isLinked);
        query.bindValue(":realName", realName);
        query.bindValue(":notebookGuid", notebookGuid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag Table insert failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void updateTagParent(String guid, String parentGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Tag set parentGuid=:parentGuid where guid=:guid");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Tag SQL tag parent update prepare has failed.");
            this.logger.log(this.logger.EXTREME, query.lastError());
        }
        query.bindValue(":parentGuid", parentGuid);
        query.bindValue(":guid", guid);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag parent update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void saveTags(List<Tag> tags) {
        int i = 0;
        while (i < tags.size()) {
            Tag tempTag = tags.get(i);
            this.addTag(tempTag, false);
            ++i;
        }
    }

    public void updateTagSequence(String guid, int sequence) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Tag set sequence=:sequence where guid=:guid");
        query.bindValue(":sequence", sequence);
        query.bindValue(":guid", guid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag sequence update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void updateTagGuid(String oldGuid, String newGuid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.prepare("Update Tag set guid=:newGuid where guid=:oldGuid");
        query.bindValue(":newGuid", newGuid);
        query.bindValue(":oldGuid", oldGuid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag guid update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        check = query.prepare("Update Tag set parentGuid=:newGuid where parentGuid=:oldGuid");
        query.bindValue(":newGuid", newGuid);
        query.bindValue(":oldGuid", oldGuid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag guid update failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        check = query.prepare("Update NoteTags set tagGuid=:newGuid where tagGuid=:oldGuid");
        query.bindValue(":newGuid", newGuid);
        query.bindValue(":oldGuid", oldGuid);
        query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "Tag guid update failed for NoteTags.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public List<Tag> getDirty() {
        ArrayList<Tag> index = new ArrayList<Tag>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        boolean check = query.exec("Select guid, parentGuid, sequence, name from Tag where isDirty = true");
        if (!check) {
            this.logger.log(this.logger.EXTREME, "Tag SQL retrieve has failed.");
        }
        while (query.next()) {
            Tag tempTag = new Tag();
            tempTag.setGuid(query.valueString(0));
            tempTag.setParentGuid(query.valueString(1));
            int sequence = new Integer(query.valueString(2));
            tempTag.setUpdateSequenceNum(sequence);
            tempTag.setName(query.valueString(3));
            if (tempTag.getParentGuid() != null && tempTag.getParentGuid().equals("")) {
                tempTag.setParentGuid(null);
            }
            index.add(tempTag);
        }
        return index;
    }

    public String findTagByName(String name) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from tag where name=:name");
        query.bindValue(":name", name);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Tag SQL retrieve has failed.");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    public String getNotebookGuid(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select notebookguid from tag where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Tag SQL retrieve has failed.");
        }
        String val = null;
        if (query.next()) {
            val = query.valueString(0);
        }
        return val;
    }

    public boolean exists(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid from tag where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Tag SQL retrieve has failed.");
        }
        boolean retval = query.next();
        return retval;
    }

    public void syncLinkedTag(Tag tag, String notebookGuid, boolean isDirty) {
        if (this.exists(tag.getGuid())) {
            Tag t = this.getTag(tag.getGuid());
            String realName = tag.getName();
            tag.setName(t.getName());
            this.updateTag(tag, isDirty, realName);
        } else {
            this.addTag(tag, isDirty, true, tag.getName(), notebookGuid);
        }
    }

    public void syncTag(Tag tag, boolean isDirty) {
        if (this.exists(tag.getGuid())) {
            this.updateTag(tag, isDirty);
        } else {
            this.addTag(tag, isDirty);
        }
    }

    public void resetDirtyFlag(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Update tag set isdirty=false where guid=:guid");
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error resetting tag dirty field.");
        }
    }

    public QIcon getIcon(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.prepare("Select icon from tag where guid=:guid")) {
            this.logger.log(this.logger.EXTREME, "Error preparing tag icon select.");
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.EXTREME, "Error finding tag icon.");
        }
        if (!query.next() || query.getBlob(0) == null) {
            return null;
        }
        QByteArray blob = new QByteArray(query.getBlob(0));
        QIcon icon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)blob)));
        return icon;
    }

    public void setIcon(String guid, QIcon icon, String type) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (icon == null) {
            if (!query.prepare("update tag set icon=null where guid=:guid")) {
                this.logger.log(this.logger.EXTREME, "Error preparing tag icon update.");
            }
        } else {
            QBuffer buffer;
            if (!query.prepare("update tag set icon=:icon where guid=:guid")) {
                this.logger.log(this.logger.EXTREME, "Error preparing tag icon update.");
            }
            if (!(buffer = new QBuffer()).open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadWrite})) {
                this.logger.log(this.logger.EXTREME, "Failure to open buffer.  Aborting.");
                return;
            }
            QPixmap p = icon.pixmap(32, 32);
            QImage i = p.toImage();
            i.save((QIODevice)buffer, type.toUpperCase());
            buffer.close();
            QByteArray b = new QByteArray(buffer.buffer());
            if (!b.isNull() && !b.isEmpty()) {
                query.bindValue(":icon", b.toByteArray());
            } else {
                return;
            }
        }
        query.bindValue(":guid", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.LOW, "Error setting tag icon. " + query.lastError());
        }
    }

    public HashMap<String, QIcon> getAllIcons() {
        HashMap<String, QIcon> values = new HashMap<String, QIcon>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        if (!query.exec("SELECT guid, icon from tag")) {
            this.logger.log(this.logger.EXTREME, "Error executing SavedSearch getAllIcons select.");
        }
        while (query.next()) {
            if (query.getBlob(1) == null) continue;
            String guid = query.valueString(0);
            QByteArray blob = new QByteArray(query.getBlob(1));
            QIcon icon = new QIcon(QPixmap.fromImage((QImage)QImage.fromData((QByteArray)blob)));
            values.put(guid, icon);
        }
        return values;
    }

    public void removeUnusedLinkedTags() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Delete from tag where linked=true and guid not in (select distinct tagguid from notetags);");
    }

    public void cleanupTags() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Update tag set parentguid=null where parentguid not in (select distinct guid from tag);");
    }

    public List<String> findChildren(String guid, List<Tag> tagList) {
        ArrayList<String> returnValue = new ArrayList<String>();
        int i = 0;
        while (i < tagList.size()) {
            if (tagList.get(i).getParentGuid().equalsIgnoreCase(guid)) {
                returnValue.add(tagList.get(i).getName());
                List<String> childMatch = this.findChildren(tagList.get(i).getGuid(), tagList);
                int j = 0;
                while (j < childMatch.size()) {
                    returnValue.add(childMatch.get(j));
                    ++j;
                }
            }
            ++i;
        }
        return returnValue;
    }
}

