/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import java.util.ArrayList;
import java.util.HashMap;

public class HistoryTable {
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public HistoryTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        this.logger.log(this.logger.HIGH, "History\u30c6\u30fc\u30d6\u30eb\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059...");
        if (!query.exec("Create table History (id integer primary key auto_increment, behaviorType varchar,guid1 varchar, guid2 varchar)")) {
            this.logger.log(this.logger.HIGH, "History\u30c6\u30fc\u30d6\u30eb\u4f5c\u6210\u5931\u6557!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.exec("Drop table History");
    }

    public void addHistory(String behaviorType, String guid1, String guid2) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        boolean excludedCheck = false;
        if (behaviorType == null) {
            return;
        }
        if (guid1 == null || guid1.equals("")) {
            return;
        }
        if (guid2 == null || guid2.equals("")) {
            return;
        }
        if (guid1.equals(guid2)) {
            return;
        }
        excludedCheck = this.db.getExcludedTable().existNote(guid1, guid2);
        if (!excludedCheck) {
            query.prepare("Insert Into History (behaviorType, guid1, guid2) Values(:behaviorType, :guid1, :guid2)");
            query.bindValue(":behaviorType", behaviorType);
            query.bindValue(":guid1", guid1);
            query.bindValue(":guid2", guid2);
            if (!query.exec()) {
                this.logger.log(this.logger.MEDIUM, "History\u30c6\u30fc\u30d6\u30eb\u3078\u306e\u30a2\u30a4\u30c6\u30e0\u8ffd\u52a0\u306b\u5931\u6557");
                this.logger.log(this.logger.MEDIUM, query.lastError());
            }
        }
    }

    public void mergeHistoryGuid(String masterGuid, String childGuid) {
        NSqlQuery histQuery = new NSqlQuery(this.db.getBehaviorConnection());
        boolean check = false;
        histQuery.prepare("Delete from history where (guid1=:oldGuid1 and guid2=:newGuid1) or (guid1=:newGuid2 and guid2=:oldGuid2)");
        histQuery.bindValue(":oldGuid1", masterGuid);
        histQuery.bindValue(":newGuid1", childGuid);
        histQuery.bindValue(":oldGuid2", masterGuid);
        histQuery.bindValue(":newGuid2", childGuid);
        check = histQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "history\u30c6\u30fc\u30d6\u30eb\u306e\u91cd\u8907\u524a\u9664\u3067\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, histQuery.lastError());
        }
        this.updateHistoryGuid(masterGuid, childGuid);
    }

    public void updateHistoryGuid(String newGuid, String oldGuid) {
        NSqlQuery histQuery = new NSqlQuery(this.db.getBehaviorConnection());
        boolean check = false;
        histQuery.prepare("Update history set guid1=:newGuid where guid1=:oldGuid");
        histQuery.bindValue(":newGuid", newGuid);
        histQuery.bindValue(":oldGuid", oldGuid);
        check = histQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "history\u30c6\u30fc\u30d6\u30eb\u306eguid1\u306e\u3068\u3053\u308d\u3067guid\u66f4\u65b0\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, histQuery.lastError());
        }
        histQuery.prepare("Update history set guid2=:newGuid where guid2=:oldGuid");
        histQuery.bindValue(":newGuid", newGuid);
        histQuery.bindValue(":oldGuid", oldGuid);
        check = histQuery.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "history\u30c6\u30fc\u30d6\u30eb\u306eguid2\u306e\u3068\u3053\u308d\u3067guid\u66f4\u65b0\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, histQuery.lastError());
        }
    }

    public HashMap<String, Integer> getBehaviorHistory(String behaviorType, String guid) {
        String key;
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        HashMap<String, Integer> behaviorHist = new HashMap<String, Integer>();
        query.prepare("Select guid2 from History where behaviorType=:behaviorType and guid1=:guid1");
        query.bindValue(":behaviorType", behaviorType);
        query.bindValue(":guid1", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "History\u30c6\u30fc\u30d6\u30eb\u304b\u3089behaviorType=" + behaviorType + "\u304b\u3064guid1=" + guid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        while (query.next()) {
            key = query.valueString(0);
            if (behaviorHist.containsKey(key)) {
                behaviorHist.put(key, (Integer)behaviorHist.get(key) + 1);
                continue;
            }
            behaviorHist.put(key, 1);
        }
        query.prepare("Select guid1 from History where behaviorType=:behaviorType and guid2=:guid2");
        query.bindValue(":behaviorType", behaviorType);
        query.bindValue(":guid2", guid);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "History\u30c6\u30fc\u30d6\u30eb\u304b\u3089behaviorType=" + behaviorType + "\u304b\u3064guid2=" + guid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        while (query.next()) {
            key = query.valueString(0);
            if (behaviorHist.containsKey(key)) {
                behaviorHist.put(key, behaviorHist.get(key) + 1);
                continue;
            }
            behaviorHist.put(key, 1);
        }
        return behaviorHist;
    }

    public void duplicateHistory(String newGuid, String oldGuid) {
        String behaviorType;
        NSqlQuery histQuery = new NSqlQuery(this.db.getBehaviorConnection());
        histQuery.prepare("Select behaviorType, guid2 from History where guid1=:oldGuid");
        histQuery.bindValue(":oldGuid", oldGuid);
        if (!histQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "History\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid1=" + oldGuid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, histQuery.lastError());
        }
        while (histQuery.next()) {
            behaviorType = histQuery.valueString(0);
            String guid2 = histQuery.valueString(1);
            this.addHistory(behaviorType, newGuid, guid2);
        }
        histQuery.prepare("Select behaviorType, guid1 from History where guid2=:oldGuid");
        histQuery.bindValue(":oldGuid", oldGuid);
        if (!histQuery.exec()) {
            this.logger.log(this.logger.MEDIUM, "History\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid2=" + oldGuid + "\u306e\u30a2\u30a4\u30c6\u30e0\u53d6\u5f97\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, histQuery.lastError());
        }
        while (histQuery.next()) {
            behaviorType = histQuery.valueString(0);
            String guid1 = histQuery.valueString(1);
            this.addHistory(behaviorType, guid1, newGuid);
        }
    }

    public void expungeHistory(String guid) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.prepare("Delete from History where guid1=:guid1 or guid2=:guid2");
        query.bindValue(":guid1", guid);
        query.bindValue(":guid2", guid);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "history\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid=" + guid + "\u306e\u30c7\u30fc\u30bf\u524a\u9664\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void expungeHistory(String guid1, String guid2) {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.prepare("Delete from History where guid1=:guid1 and guid2=:guid2");
        query.bindValue(":guid1", guid1);
        query.bindValue(":guid2", guid2);
        boolean check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "history\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid1=" + guid1 + "\u304b\u3064guid2=" + guid2 + "\u306e\u30c7\u30fc\u30bf\u524a\u9664\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
        query.prepare("Delete from History where guid1=:guid1 and guid2=:guid2");
        query.bindValue(":guid1", guid2);
        query.bindValue(":guid2", guid1);
        check = query.exec();
        if (!check) {
            this.logger.log(this.logger.MEDIUM, "history\u30c6\u30fc\u30d6\u30eb\u304b\u3089guid1=" + guid2 + "\u304b\u3064guid2=" + guid1 + "\u306e\u30c7\u30fc\u30bf\u524a\u9664\u306b\u5931\u6557");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public void addSameTagHistory(String noteGuid, String tagGuid) {
        if (noteGuid == null || noteGuid.equals("")) {
            return;
        }
        if (tagGuid == null || tagGuid.equals("")) {
            return;
        }
        ArrayList<String> prevTags = new ArrayList<String>(this.db.getNoteTable().noteTagsTable.getNoteTags(noteGuid));
        int i = 0;
        while (i < prevTags.size()) {
            System.out.println((String)prevTags.get(i));
            if (tagGuid.equals(prevTags.get(i))) {
                return;
            }
            ++i;
        }
        ArrayList<String> sameTagNoteGuids = new ArrayList<String>(this.db.getNoteTable().noteTagsTable.getTagNotes(tagGuid));
        int i2 = 0;
        while (i2 < sameTagNoteGuids.size()) {
            String guid = (String)sameTagNoteGuids.get(i2);
            this.addHistory("sameTag", noteGuid, guid);
            ++i2;
        }
    }

    public void addSameNotebookHistory(String noteGuid, String notebookGuid) {
        if (noteGuid == null || noteGuid.equals("")) {
            return;
        }
        if (notebookGuid == null || notebookGuid.equals("")) {
            return;
        }
        ArrayList<String> sameNotebookNoteGuids = new ArrayList<String>(this.db.getNoteTable().getNotesByNotebook(notebookGuid));
        int i = 0;
        while (i < sameNotebookNoteGuids.size()) {
            String guid = (String)sameNotebookNoteGuids.get(i);
            if (!noteGuid.equals(guid)) {
                this.addHistory("sameNotebook", noteGuid, guid);
            }
            ++i;
        }
    }

    public int getHistoryCount() {
        NSqlQuery query = new NSqlQuery(this.db.getBehaviorConnection());
        query.exec("Select count(*) from History");
        query.next();
        int returnValue = new Integer(query.valueString(0));
        return returnValue;
    }
}

