/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.nevernote.sql;

import cx.fbn.nevernote.sql.DatabaseConnection;
import cx.fbn.nevernote.sql.DeletedItemRecord;
import cx.fbn.nevernote.sql.driver.NSqlQuery;
import cx.fbn.nevernote.utilities.ApplicationLogger;
import cx.fbn.nevernote.utilities.ListManager;
import java.util.ArrayList;
import java.util.List;

public class DeletedTable {
    ListManager parent;
    private final ApplicationLogger logger;
    private final DatabaseConnection db;

    public DeletedTable(ApplicationLogger l, DatabaseConnection d) {
        this.logger = l;
        this.db = d;
    }

    public void createTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        this.logger.log(this.logger.HIGH, "Creating table DeletedItems...");
        if (!query.exec("Create table DeletedItems (guid varchar primary key, type varchar)")) {
            this.logger.log(this.logger.HIGH, "Table DeletedItems creation FAILED!!!");
        }
    }

    public void dropTable() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Drop table DeletedItems");
    }

    public void addDeletedItem(String guid, String type) {
        if (this.exists(guid, type)) {
            return;
        }
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Insert Into DeletedItems (guid, type) Values(:guid, :type)");
        query.bindValue(":guid", guid);
        query.bindValue(":type", type);
        if (!query.exec()) {
            this.logger.log(this.logger.MEDIUM, "Insert into deleted items failed.");
            this.logger.log(this.logger.MEDIUM, query.lastError());
        }
    }

    public boolean exists(String guid, String type) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("Select guid, type from DeletedItems where guid=:guid and type=:type");
        query.bindValue(":guid", guid);
        query.bindValue(":type", type);
        query.exec();
        return query.next();
    }

    public void expungeDeletedItem(String guid, String type) {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.prepare("delete from DeletedItems where guid=:guid and type=:type");
        query.bindValue(":guid", guid);
        query.bindValue(":type", type);
        if (!query.exec()) {
            this.logger.log(this.logger.LOW, "Expunge deleted items failed.");
            this.logger.log(this.logger.LOW, query.lastError());
        }
    }

    public List<DeletedItemRecord> getAllDeleted() {
        this.logger.log(this.logger.HIGH, "Entering DeletedTable.getAllDeleted");
        ArrayList<DeletedItemRecord> list = new ArrayList<DeletedItemRecord>();
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("Select guid, type from DeletedItems");
        while (query.next()) {
            DeletedItemRecord record = new DeletedItemRecord();
            record.guid = query.valueString(0);
            record.type = query.valueString(1);
            list.add(record);
        }
        this.logger.log(this.logger.HIGH, "Leaving DeletedTable.getAllDeleted");
        return list;
    }

    public void expungeAllDeletedRecords() {
        NSqlQuery query = new NSqlQuery(this.db.getConnection());
        query.exec("delete from DeletedItems");
    }
}

