using NDac.Modules.Extensions;

namespace System.Data
{
	/// <summary>
	/// データテーブルの拡張メソッドのクラスを表します。
	/// </summary>
	static class DataTableExtension
	{
		/// <summary>
		/// 対象データテーブルから削除された行を管理しているデータテーブルを取得します。
		/// </summary>
		/// <param name="table">データテーブル</param>
		/// <returns>削除された行を管理しているデータテーブル</returns>
		public static DataTable GetDeleted( this DataTable table )
		{
			if( ( table.Site != null ) && ( table.Site is DataTableSite ) )
			{
				DataTableSite site = ( DataTableSite )table.Site;

				return( site.Component.DeletedRowTableManager.Table );
			}
			else
			{
				return( table.Clone() );	//スキーマ情報のみを返す。
			}
		}
	}
}
