using System;
using NDac.Datas;
using NDac.Gateways;
using NDac.Keys;
using NDac.Modules;
using NDac.Modules.Attributes;
using NDac.Modules.Entities;

namespace NDac.Modules.DataTransferObjects
{
	/// <summary>
	/// Publisherテーブルのデータ変換オブジェクトを表します。
	/// </summary>
	[ Serializable ]
	public partial class PublisherDTO : DataTransferObject< PublisherKey, PublisherEntity >
	{
		private long _id;
		private string _name;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public PublisherDTO()
			: base()
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="entity">エンティティ</param>
		public PublisherDTO( PublisherEntity entity )
			: base( entity )
		{
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public PublisherDTO( long primaryKey )
		{
			this._id = primaryKey;
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		public PublisherDTO( PublisherKey primaryKey )
		{
			this._id = primaryKey.Id;
		}

		/// <summary>
		/// Idを表します。
		/// </summary>
		[ PrimaryKey( "Id", typeof( long ) ) ]
		public long Id
		{
			get
			{
				return( this._id );
			}
			set
			{
				this._id = value;
			}
		}

		/// <summary>
		/// Nameを表します。
		/// </summary>
		public string Name
		{
			get
			{
				return( StringCutDowner.Variable( this._name, 50 ) );
			}
			set
			{
				this._name = StringCutDowner.Variable( value, 50 );
			}
		}

		/// <summary>
		/// データ変換オブジェクトの内容をコピーします。
		/// </summary>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		protected override void Copy( DataTransferObject< PublisherKey, PublisherEntity > source )
		{
			this.Copy( ( PublisherDTO )source );
		}

		/// <summary>
		/// データ変換オブジェクトの内容をコピーします。
		/// </summary>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		public void Copy( PublisherDTO source )
		{
			this.Id = source.Id;
			this.Name = source.Name;
		}

		/// <summary>
		/// エンティティの内容をコピーします。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		public override void Copy( PublisherEntity source )
		{
			this.FillValue( source );
		}

		/// <summary>
		/// データ変換オブジェクトの内容をエンティティにコピーします。
		/// </summary>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		/// <param name="destination">コピー先のエンティティ</param>
		public static void Copy( PublisherDTO source, PublisherEntity destination )
		{
			source.FillTo( destination );
		}

		/// <summary>
		/// エンティティの内容をデータ変換オブジェクトにコピーします。
		/// </summary>
		/// <param name="source">コピー元のエンティティ</param>
		/// <param name="destination">コピー先のデータ変換オブジェクト</param>
		public static void Copy( PublisherEntity source, PublisherDTO destination )
		{
			destination.FillValue( source );
		}

		/// <summary>
		/// エンティティより値を充填します。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillValue( IEntity entity )
		{
			this.FillValue( ( PublisherEntity )entity );
		}

		/// <summary>
		/// エンティティより値を充填します。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillValue( PublisherEntity entity )
		{
			this._id = entity.Id;
			this._name = entity.Name;
		}

		/// <summary>
		/// データ変換オブジェクトの内容をエンティティに反映させます。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillTo( IEntity entity )
		{
			this.FillTo( ( PublisherEntity )entity );
		}

		/// <summary>
		/// データ変換オブジェクトの内容をエンティティに反映させます。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		protected override void FillTo( PublisherEntity entity )
		{
			entity.Id = this._id;
			entity.Name = this._name;
		}

		/// <summary>
		/// プライマリキーでデータを充填されたテーブルモジュールを取得します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>テーブルモジュール</returns>
		protected override ITableModule LoadModule( IKey primaryKey )
		{
			return( this.LoadModule( ( PublisherKey )primaryKey ) );
		}

		/// <summary>
		/// プライマリキーでデータを充填されたテーブルモジュールを取得します。
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>テーブルモジュール</returns>
		protected override ITableModule LoadModule( PublisherKey primaryKey )
		{
			DataSetHolder holder = new DataSetHolder();

			PublisherGateway gateway = new PublisherGateway( holder );

			PublisherModule module = new PublisherModule( holder );

			gateway.LoadBy( primaryKey );

			return( module );
		}

		/// <summary>
		/// プライマリキーに変換します。
		/// </summary>
		/// <returns>プライマリキー</returns>
		protected override PublisherKey ToPrimaryKey()
		{
			return( new PublisherKey( this.Id ) );
		}
	}

	/// <summary>
	/// Publisherテーブルエンティティの拡張メソッド定義クラスを表します。
	/// </summary>
	public static class PublisherEntityExtension
	{
		/// <summary>
		/// データ変換オブジェクトの内容をコピーします。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		/// <param name="source">コピー元のデータ変換オブジェクト</param>
		public static void Copy( this PublisherEntity entity, PublisherDTO source )
		{
			PublisherDTO.Copy( source, entity );
		}

		/// <summary>
		/// データ変換オブジェクトに変換します。
		/// </summary>
		/// <param name="entity">エンティティ</param>
		/// <returns>データ変換オブジェクト</returns>
		public static PublisherDTO ToDataTransferObject( this PublisherEntity entity )
		{
			return( new PublisherDTO( entity ) );
		}
	}
}
