using System;
using NDac.Keys;
using NDac.Modules.Entities;
using NDac.RemoteFacades;

namespace NDac.IdentityMappings
{
	/// <summary>
	/// Authorテーブルのファインダを表します。
	/// </summary>
	public partial class AuthorFinder
	{
		private static AuthorFinder _instance;
		private IdentityMap< AuthorKey, AuthorEntity > _identityMap = new IdentityMap< AuthorKey, AuthorEntity >();

		/// <summary>
		/// コンストラクタ
		/// </summary>
		private AuthorFinder()
		{
			this.Constructed();
		}

		/// <summary>
		/// インスタンスを表します。
		/// </summary>
		public static AuthorFinder Instance
		{
			get
			{
				if( _instance == null )
				{
					_instance = new AuthorFinder();
				}

				return( _instance );
			}
		}

		/// <summary>
		/// キー情報に一致するAuthorテーブルのエンティティを取得します。
		/// <para>まず一意マッピングを検索し、一意マッピングに存在する値を返します。</para>
		/// <para>一意マッピングに存在しない場合はFurnaceModelテーブルを検索し、Authorテーブルに存在する値を返します。</para>
		/// <para>一意マッピング，Authorテーブルのいずれにも存在しない場合はnullを返します。</para>
		/// </summary>
		/// <param name="id">Id</param>
		/// <returns>Authorテーブルのエンティティ</returns>
		public AuthorEntity Find( long id )
		{
			return( this.Find( new AuthorKey( id ) ) );
		}

		/// <summary>
		/// キー情報に一致するAuthorテーブルのエンティティを取得します。
		/// <para>まず一意マッピングを検索し、一意マッピングに存在する値を返します。</para>
		/// <para>一意マッピングに存在しない場合はAuthorテーブルを検索し、Authorテーブルに存在する値を返します。</para>
		/// <para>一意マッピング，Authorテーブルのいずれにも存在しない場合はnullを返します。</para>
		/// </summary>
		/// <param name="primaryKey">プライマリキー</param>
		/// <returns>Authorテーブルのエンティティ</returns>
		public AuthorEntity Find( AuthorKey primaryKey )
		{
			if( !this._identityMap.ContainsKey( primaryKey ) )
			{
				AuthorFacade facade = new AuthorFacade();

				facade.LoadBy( primaryKey );

				if( 0 < facade.Count )
				{
					this._identityMap.Add( primaryKey, facade[ primaryKey ] );
				}
				else
				{
					this._identityMap.Add( primaryKey, null );
				}
			}

			this.Finded( primaryKey, this._identityMap[ primaryKey ] );

			return( this._identityMap[ primaryKey ] );
		}

		/// <summary>
		/// テーブルより全データを充填し、一意マッピングに登録します。
		/// </summary>
		public void LoadAll()
		{
			AuthorFacade facade = new AuthorFacade();

			facade.LoadAll();

			if( this._identityMap.Count != facade.Count )
			{
				foreach( AuthorEntity entity in facade )
				{
					if( !this._identityMap.ContainsKey( entity.GetPrimaryKey() ) )
					{
						this._identityMap.Add( entity.GetPrimaryKey(), entity );
					}
				}
			}
		}

		/// <summary>
		/// 一意マッピングに存在する全ての値をクリアします。
		/// </summary>
		public void Clear()
		{
			this._identityMap.Clear();
		}

		/// <summary>
		/// コンストラクタが呼び出された後にコールされます。
		/// </summary>
		partial void Constructed();

		/// <summary>
		/// Find終了処理を実行します。
		/// </summary>
		/// <param name="key">キー</param>
		/// <param name="entity">Find処理結果のエンティティ</param>
		partial void Finded( AuthorKey key, AuthorEntity entity );
	}
}
