using System;

namespace NDac.Modules
{
	/// <summary>
	/// インデックスアクセスサポートクラスを表します。
	/// </summary>
	public class IndexNumber
	{
		private int _number;

		private static IndexNumber _zero = new IndexNumber( 0 );
		private static IndexNumber _last = new IndexNumber( -1 );

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="number">インデックス値</param>
		public IndexNumber( int number )
		{
			this._number = number;
		}

		/// <summary>
		/// インデックス値を表します。
		/// </summary>
		public int Number
		{
			get
			{
				return( this._number );
			}
		}

		/// <summary>
		/// 0番目のインデックスを表します。
		/// </summary>
		public static IndexNumber Zero
		{
			get
			{
				return( _zero );
			}
		}

		/// <summary>
		/// 最終インデックスを表します。
		/// </summary>
		public static IndexNumber Last
		{
			get
			{
				return( _last );
			}
		}

		//TODO:==等のサポート
	}
}
