using System;

namespace NDac.Keys
{
	/// <summary>
	/// IdNumberingテーブルのプライマリキーを表します。
	/// </summary>
	public class IdNumberingKey : Key
	{
		private string _tableName;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="tableName">TableName</param>
		public IdNumberingKey( string tableName )
		{
			this._tableName = tableName;
		}

		/// <summary>
		/// TableName
		/// </summary>
		public string TableName
		{
			get
			{
				return( this._tableName );
			}
		}
	}
}
