package jp.co.argo21.nautica.ejbtest;
import static org.junit.Assert.*;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.junit.After;
import org.junit.Test;

import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.filter.AttributeFilter;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.sample.model.AppKind;
import jp.co.argo21.nautica.workflow.sample.model.AppTransaction;
import jp.co.argo21.nautica.workflow.sample.model.Application;
import jp.co.argo21.nautica.workflow.sample.model.dao.AppTransactionDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.ApplicationDAO;
import jp.co.argo21.nautica.workflow.sample.model.dao.DAOFactory;
import jp.co.argo21.nautica.workflow.sample.model.dao.OvertimeAppDAO;
import jp.co.argo21.nautica.workflow.sample.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;


public class XPDLTest {

	private static final int QUEUE_WAIT = 10000;
	private WorkflowServiceAccessor accessor;
	private String sessionId;
	private String pid;
	private String appId; 
	private User usr;
	private static final String APP_KIND_ID = "overtime";

	/**
	 * 実施単位１；ログイン
	 */
	@Test
	public void unit01(){

		accessor = SingletonServices.getInstance().getAccessor("UID110101", "taro");
		try {
			sessionId = accessor.open();
		} catch (ConnectionFailedException e) {
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位２：メニュー画面
	 */
	@Test
	public void unit02(){

		try {
			//試験１　ログイン
			unit01();


			//試験２　getUser
			UserManager userManager = SingletonServices.getInstance().getUserManager();
			usr = userManager.getUser("UID110101");

			//試験３　getOrganizationByUser
			OrganizationManager orgManager = SingletonServices.getInstance().getOrganizationManager();
			Organization[] org = orgManager.getOrganizationByUser(usr);


			//確認１
			assertEquals("アルゴ 太郎", usr.getName());
			//確認２
			assertEquals("企画営業部一課", org[0].getName());

		} catch(Exception e){
			e.printStackTrace();
			fail();
		}finally {

		}
	}


	/**
	 * 実施単位３：ログアウト
	 */
	@Test(expected= InvalidSessionException.class)
	public void unit03() throws InvalidSessionException{
		WorkItemHandler wih = null;
		try {
			//試験１　ログイン
			unit01();
			wih = accessor.getWorkItemHandler();
			//試験２　ログアウト
			accessor.close();
			
			//例外発生回避のため、再度エンジンに接続
			unit01();
			
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

		try {
			wih.getWorkItems(sessionId, null);
			fail();
		} catch (InvalidSessionException e) {
			throw e;
		} catch (InvalidFilterException e) {
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位４：申請一覧画面
	 */
	@Test
	public void unit04(){

		try {
			//試験１　ユーザー取得
			unit02();

			//試験２　ロールを取得する。
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role[] roles = roleManager.getAttachedRoles(usr);


			//確認１
			Set<String> roleSet = new HashSet<String>();
			roleSet.add("企画営業部ロール");
			roleSet.add("一般社員ロール");

			for (int i=0; i < roles.length; i++){
				String tempRole = roles[i].getName();
				System.out.println(tempRole);
				assertTrue(roleSet.contains(tempRole));
			}
			assertEquals(2, roles.length);

		}catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位５　申請開始
	 */
	@Test
	public void unit05(){
		try {
			//試験１　ユーザ取得
			unit02();

			//試験２　createProcess

			//申請書番号を決定
			Date date = new Date();
			SimpleDateFormat formatter;
			StringBuffer number = new StringBuffer();
			formatter = new SimpleDateFormat("yyyyMMddHHmmss");
			number.append(formatter.format(date));
			//appId = number.toString();
			appId = UniqueKeyGenerator.generate(APP_KIND_ID);

			// 申請トランザクションテーブルにレコードを追加
			AppKind appKind = DAOFactory.getAppKindDAO().getAppKindFromID(APP_KIND_ID);
			String appKindID = appKind.getAppkindID();
			AppTransactionDAO apptransDao = DAOFactory.getAppTransactionDAO();
			System.out.println("appId: " + appId);
			System.out.println("appKindID: " + appKindID);
			System.out.println("userID: " + usr.getID());
			apptransDao.insertForOverTime(appId, appKindID, usr.getID());

			// 各申請のテーブルに申請書番号の空レコードを追加
			OvertimeAppDAO appKindDao 
			= (OvertimeAppDAO) DAOFactory.getApplicationDAOFromAppKindID(APP_KIND_ID);
			appKindDao.insertAppNo(appId);
			ApplicationDAO appDao = DAOFactory.getApplicationDAO();
			appDao.insert(appId, appKindID, usr.getID());

			String pdid = "Overtime-0";

			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();

			pid = weh.createProcess(sessionId, pdid, appId);

			System.out.println("pid: " + pid);
			//試験３　assignProcessAttribute
			VariableBean state = new VariableBean();
			state.setName(Constants.STATE);
			state.setValue(StateConstants.APPLY_WAIT);
			state.setType(1);
			weh.assignProcessAttribute(sessionId, pid, state);

			VariableBean appNo = new VariableBean();
			appNo.setName(Constants.APPLICATION_NO);
			appNo.setValue(appId);
			appNo.setType(1);
			weh.assignProcessAttribute(sessionId, pid, appNo);
			
			VariableBean orgCode = new VariableBean();
			orgCode.setName(Constants.ORGANIZATION_CODE);
			orgCode.setValue("E110");
			orgCode.setType(1);
			weh.assignProcessAttribute(sessionId, pid, orgCode);
			
			//試験４　startProcess
			weh.startProcess(sessionId, pid);
			
			//確認１　ログが出力されることを確認する
			//確認２　createProcessは試験３が正常に実行されることで確認する

			//確認３
			Attribute stateCheck= weh.getProcessAttributeValue(sessionId, pid, Constants.STATE);
			assertEquals(stateCheck.getValue(), StateConstants.APPLY_WAIT);
			Attribute appNoCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.APPLICATION_NO);
			assertEquals(appId, appNoCheck.getValue());

			//確認４
			Set<Integer> stateInt = new HashSet<Integer>();
			stateInt.add(2);
			stateInt.add(4);
			stateInt.add(5);
			stateInt.add(6);
			
			Thread.sleep(QUEUE_WAIT);
			
			ProcessState[] proState = weh.getProcessStates(sessionId, pid, null);
			for(int i=0; i < proState.length; i++){
				int num = proState[i].toInt();
				assertTrue(stateInt.contains(num));
			}
			assertEquals(4, proState.length);

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		} 
	}


	/**
	 * 実施単位６　申請キャンセル
	 * @throws InvalidWorkItemException 
	 */
	@Test
	public void unit06(){
		try {
			//試験１　ログイン

			//試験２　実施単位５を実行
			unit05();
			
			//試験３　プロセス変数[申請書番号]を空文字に設定
			WorkItemHandler wih = accessor.getWorkItemHandler();
			System.out.println("appId: " + appId);
			AttributeFilter appNoFilter = new AttributeFilter(Constants.APPLICATION_NO, 1, appId);
			WorkItem[] workItems = wih.getWorkItems(sessionId, appNoFilter);
			System.out.println("workItems.length: " + workItems.length);
			String wid = workItems[0].getID();
			System.out.println("wid : " + wid);
			
			// 作業項目属性を設定
			VariableBean appNoCancel = new VariableBean();
			appNoCancel.setName(Constants.APPLICATION_NO);
			appNoCancel.setValue("");
			appNoCancel.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appNoCancel);

			//試験４　completeWorkItem
			wih.completeWorkItem(sessionId, wid);

			//確認１
			Thread.sleep(QUEUE_WAIT);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute stateCheck= weh.getProcessAttributeValue(sessionId, pid, Constants.APPLICATION_NO);
			System.out.println("getValue : " + stateCheck.getValue());
			System.out.println("expected : ");
			assertEquals("", stateCheck.getValue());
			
			//確認３
			ProcessState[] proState = weh.getProcessStates(sessionId, pid, null);
			assertEquals(0, proState.length);
			
			//確認２
//			try{
//			wih.completeWorkItem(sessionId, wid);
//			} catch (InvalidWorkItemException e){

		}catch(Exception e){
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * 実施単位７　申請内容入力待ち申請一覧取得
	 */
	@Test
	public void unit07(){
		try{
			//準備作業
			unit05();
			//試験１　ログイン

			WorkItemHandler wih = accessor.getWorkItemHandler();
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			//試験２　getWorkItems
			AttributeFilter state = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPLY_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, state);

			//試験３　getWorkItemAttributeValue
			boolean checkPid = false;
			boolean checkAppId = false;
			for (int i=0; i<items.length; i++) {
				//確認１
				if (items[i].getProcessID().equals(pid)){
					checkPid = true;
				}

				Attribute attr 
				= weh.getProcessAttributeValue(sessionId, items[i].getProcessID(), Constants.APPLICATION_NO);
				//確認２
				if (attr.getValue().equals(appId)){
					checkAppId = true;
				}
			}
			//確認１
			assertTrue(checkPid);
			//確認２
			assertTrue(checkAppId);
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位８　申請
	 */
	@Test
	public void unit08(){
		try{
			//試験１　ログイン
			//試験２　実施単位５
			unit05();

			//試験３　申請トランザクションテーブルの[承認ブロック番号]"0"の[状態]を"申請"に、[対象日]を申請日にする
			//試験４　申請トランザクションテーブルの[承認ブロック番号]"1"の[状態]を"待ち"に変更する。
			Application app = new Application();
			app.setDate(new Timestamp(System.currentTimeMillis()));
			AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
			AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appId);

			for (int i=0; i<appTranses.length; i++) {
				AppTransaction appTrans = appTranses[i];
				int approveAccountID = appTrans.getApproveAccountID();
				if (approveAccountID == 0) {
					appTrans.setAppStatus(StateConstants.STATUS_TRANS_APPLY);
					appTrans.setAppUserID(usr.getID());
					appTrans.setDate(app.getDate());	//日付をどこかから取ってくればOK
					appTransDao.updateAppTransaction(appTrans);
				} else if (approveAccountID == 1) {
					appTrans.setAppStatus(StateConstants.STATUS_TRANS_WAIT);
					appTransDao.updateStatus(appTrans);
				} else if (approveAccountID == 2 || approveAccountID ==3){
					appTrans.setAppStatus(StateConstants.STATUS_TRANS_NOT_REACH);
					appTransDao.updateStatus(appTrans);
				}
			}

			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPLY_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
System.out.println("length of items: " + items.length);
			String wid = items[items.length-1].getID();
System.out.println("wid: " + wid);

			//試験５　assignWorkItemAttribute
			VariableBean appDate = new VariableBean();
			appDate.setName(Constants.APPLY_DATE);
			appDate.setValue(app.getDate().toString());
			appDate.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appDate);

			VariableBean state = new VariableBean();
			state.setName(Constants.STATE);
			state.setValue(StateConstants.APPROVAL_WAIT);
			state.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, state); 
			//試験６　completeWorkItem
			wih.completeWorkItem(sessionId, wid);

			//確認１
			Thread.sleep(20000);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute appDateCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.APPLY_DATE);
			assertEquals(appDate.getValue(), appDateCheck.getValue());
			Attribute stateCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.STATE);
			assertEquals(StateConstants.APPROVAL_WAIT, stateCheck.getValue());

		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位９　承認状況一覧
	 */
	@Test
	public void unit09(){
		try{
			//試験１　ログイン
			unit08();

			//試験　getProcesses
			List appIDList = new ArrayList();
			// ユーザがフローに参加している申請の申請書番号を取得
			AppTransaction[] apptsByUser = DAOFactory.getAppTransactionDAO().getAppTransactionsByUserID(usr.getID());
			addAppID(appIDList, apptsByUser);

			// ユーザのロールがフローに含まれる申請の申請書番号を取得
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role[] roles = roleManager.getAttachedRoles(usr);
			AppTransactionDAO apptDAO = DAOFactory.getAppTransactionDAO();
			for (int i = 0; i < roles.length; i++) {
				AppTransaction[] apptsByRole = apptDAO.getAppTransactionsByRoleID(roles[i].getID());
				addAppID(appIDList, apptsByRole);
			}

			// 取得した申請書番号をもとに、プロセスが実行中である申請を取得
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			List<Process[]> appList = new ArrayList<Process[]>();
			ApplicationDAO appDAO = DAOFactory.getApplicationDAO();
			Iterator ite = appIDList.iterator();
			while (ite.hasNext()) {
				String appID = (String) ite.next();

				// フィルターをセット
				NameFilter nameFilter = new NameFilter(appID, 1);
				StateFilter stateFilter = new StateFilter(ProcessState.OPEN_RUNNING);
				Filter[] filter = new Filter[2];
				filter[0] = nameFilter;
				filter[1] = stateFilter;
				GroupFilter groupFilter = new GroupFilter(filter);
				Process[] processes = weh.getProcesses(sessionId, groupFilter);
				appList.add(processes);
			}

			//確認１
			boolean checkProcId = false;
			for (Process[] proc : appList){
				for(int i = 0; i < proc.length; i++){
					if (proc[i].getID().equals(pid)){
						checkProcId = true;
					}
				}
			}
			assertTrue(checkProcId);
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位１０　承認待ち申請一覧取得
	 */
	@Test
	public void unit10(){
		try{
			//準備
			unit08();
			accessClose();

			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID110001", "jiro");
			sessionId = accessor.open();
			
			//試験２　getWorkItems
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPROVAL_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);

			//試験３　getWorkItemAttributeValue
			boolean checkAppId = false;
			for (int i = 0; i < items.length; i++) {
				WorkItem item = items[i];
				String wid = item.getID();

				String appID = wih.getWorkItemAttributeValue(
						sessionId, wid, Constants.APPLICATION_NO).getValue();

				//確認１
				//確認２で正常が確認されることによって確認する。
				
				//確認２
				if (appID.equals(appId)){
					checkAppId = true;
				}
			}
			assertTrue(checkAppId);
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位１１　差戻し
	 */
	@Test
	public void unit11() {
		try{
			//準備
			unit08();
			accessClose();

			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID110001", "jiro");
			sessionId = accessor.open();
			
			//ワークアイテムを取得
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPROVAL_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
			String wid = items[items.length-1].getID();

			//試験２　申請トランザクションテーブルの[状態]が"待ち"になっている最小の[承認ブロック番号]を取得する
			AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
			AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appId);
			AppTransaction appTrans = null;
			for (int i = 0; i < appTranses.length; i++) {
				String status = appTranses[i].getAppStatus();
				if ((StateConstants.STATUS_TRANS_WAIT).equals(status)) {
					appTrans = appTranses[i];
					break;
				}
			}

			//試験３　申請書番号と取得した承認ブロック番号で申請トランザクションテーブルを更新
			if (appTrans != null) {
				appTrans.setAppStatus(StateConstants.STATUS_TRANS_RETRY);
				appTrans.setAppUserID(usr.getID());
				appTrans.setComment("retry!");
				appTrans.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
				appTransDao.updateAppTransaction(appTrans);

				// 申請者の[状態]を”待ち”に変更
				AppTransaction applyTrans = appTransDao.getAppTransactionByAppIDBlockID(appId, 0);
				applyTrans.setAppStatus(StateConstants.STATUS_TRANS_WAIT);
				appTransDao.updateAppTransaction(applyTrans);
			}

			//試験４　assignWorkItemAttribute
			VariableBean appState = new VariableBean();
			appState.setName(Constants.STATE);
			appState.setValue(StateConstants.APPLY_WAIT);
			appState.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appState);

			VariableBean appResult = new VariableBean();
			appResult.setName(Constants.APPROVAL_RESULT);
			appResult.setValue(Constants.RETRY);
			appResult.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appResult);

			//試験５　completeWorkItem
			wih.completeWorkItem(sessionId, wid);


			//確認１
			Thread.sleep(QUEUE_WAIT);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute appStateCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.STATE);
			assertEquals(StateConstants.APPLY_WAIT, appStateCheck.getValue());
			Attribute appResultCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.APPROVAL_RESULT);
			assertEquals(Constants.RETRY, appResultCheck.getValue());

			//確認２
//			try{
//				wih.completeWorkItem(sessionId, wid);
//				fail();
//			} catch (InvalidWorkItemException e){
//				throw e;
//			}
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位１２＿１　承認処理（課長承認）
	 */
	@Test
	public void unit12_1() {
		try{
			//準備
			unit08();
			accessClose();

			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID110001", "jiro");
			sessionId = accessor.open();
			
			//ワークアイテムを取得
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPROVAL_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
			String wid = items[items.length-1].getID();

			//試験２　申請トランザクションテーブルの[状態]が"待ち"になっている最小の[承認ブロック番号]を取得する
			AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
			AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appId);
			AppTransaction appTrans = null;
			AppTransaction nextAppTrans = null;
			for (int i = 0; i < appTranses.length; i++) {
				String status = appTranses[i].getAppStatus();
				if ((StateConstants.STATUS_TRANS_WAIT).equals(status)) {
					appTrans = appTranses[i];
					if ( i < appTranses.length-1) {
						nextAppTrans = appTranses[i+1];
					}
					break;
				}
			}

			//試験３　申請書番号と取得した承認ブロック番号で申請トランザクションテーブルを更新
			if (appTrans != null) {
				appTrans.setAppStatus(StateConstants.STATUS_TRANS_APPROVE);
				appTrans.setAppUserID(usr.getID());
				appTrans.setComment("OK!");
				appTrans.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
				appTransDao.updateAppTransaction(appTrans);
			}

			//試験４　assignWorkItemAttribute
			// 申請トランザクションテーブルの更新した次のレコードの
			// [状態]を"WAIT"に更新
			int approveAccount = 4;
			if (nextAppTrans != null && nextAppTrans.getApproveAccountID() < approveAccount) {
				nextAppTrans.setAppStatus(StateConstants.STATUS_TRANS_WAIT);
				appTransDao.updateStatus(nextAppTrans);
			}

			// 作業項目のプロセス変数[承認結果]を"ACK"に設定
			VariableBean appResult = new VariableBean();
			appResult.setName(Constants.APPROVAL_RESULT);
			appResult.setValue(Constants.ACK);
			appResult.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appResult);

			// 最終承認者の場合、プロセス変数[状態]を"CONFIRM_WAIT"に更新
			int approveCount = 4;
			if (approveCount == appTrans.getApproveAccountID()+1) {
				VariableBean state = new VariableBean();
				state.setName(Constants.STATE);
				state.setValue(StateConstants.CONFIRM_WAIT);
				state.setType(1);
				wih.assignWorkItemAttribute(sessionId, wid, state);
			}

			//試験５　completeWorkItem
			wih.completeWorkItem(sessionId, wid);


			//確認１
			Thread.sleep(25000);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute appStateCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.STATE);
			assertEquals(StateConstants.APPROVAL_WAIT, appStateCheck.getValue());
			Attribute appResultCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.APPROVAL_RESULT);
			assertEquals(Constants.ACK, appResultCheck.getValue());

			//確認２
//			try{
//				wih.completeWorkItem(sessionId, wid);
//				fail();
//			} catch (InvalidWorkItemException e){
//				throw e;
//			}

		} catch (Exception e){
			e.printStackTrace();
			fail();
		}

	}

	
	/**
	 * 実施単位１２＿２　承認処理（部長承認）
	 */
	@Test
	public void unit12_2() {
		try{
			//準備
			unit12_1();
			accessClose();

			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID100001", "saburo");
			sessionId = accessor.open();
			
			//ワークアイテムを取得
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPROVAL_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
			String wid = items[items.length-1].getID();

			//試験２　申請トランザクションテーブルの[状態]が"待ち"になっている最小の[承認ブロック番号]を取得する
			AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
			AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appId);
			AppTransaction appTrans = null;
			AppTransaction nextAppTrans = null;
			for (int i = 0; i < appTranses.length; i++) {
				String status = appTranses[i].getAppStatus();
				if ((StateConstants.STATUS_TRANS_WAIT).equals(status)) {
					appTrans = appTranses[i];
					if ( i < appTranses.length-1) {
						nextAppTrans = appTranses[i+1];
					}
					break;
				}
			}

			//試験３　申請書番号と取得した承認ブロック番号で申請トランザクションテーブルを更新
			if (appTrans != null) {
				appTrans.setAppStatus(StateConstants.STATUS_TRANS_APPROVE);
				appTrans.setAppUserID(usr.getID());
				appTrans.setComment("OK!");
				appTrans.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
				appTransDao.updateAppTransaction(appTrans);
			}

			//試験４　assignWorkItemAttribute
			// 申請トランザクションテーブルの更新した次のレコードの
			// [状態]を"WAIT"に更新
			int approveAccount = 4;
			if (nextAppTrans != null && nextAppTrans.getApproveAccountID() < approveAccount) {
				nextAppTrans.setAppStatus(StateConstants.STATUS_TRANS_WAIT);
				appTransDao.updateStatus(nextAppTrans);
			}

			// 作業項目のプロセス変数[承認結果]を"ACK"に設定
			VariableBean appResult = new VariableBean();
			appResult.setName(Constants.APPROVAL_RESULT);
			appResult.setValue(Constants.ACK);
			appResult.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appResult);

			// 最終承認者の場合、プロセス変数[状態]を"CONFIRM_WAIT"に更新
			int approveCount = 4;
			if (approveCount == appTrans.getApproveAccountID()+1) {
				VariableBean state = new VariableBean();
				state.setName(Constants.STATE);
				state.setValue(StateConstants.CONFIRM_WAIT);
				state.setType(1);
				wih.assignWorkItemAttribute(sessionId, wid, state);
			}

			//試験５　completeWorkItem
			wih.completeWorkItem(sessionId, wid);


			//確認１
			Thread.sleep(QUEUE_WAIT);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute appStateCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.STATE);
			assertEquals(StateConstants.APPROVAL_WAIT, appStateCheck.getValue());
			Attribute appResultCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.APPROVAL_RESULT);
			assertEquals(Constants.ACK, appResultCheck.getValue());
			
			//確認２
//			try{
//				wih.completeWorkItem(sessionId, wid);
//				fail();
//			} catch (InvalidWorkItemException e){
//				throw e;
//			}

		} catch (Exception e){
			e.printStackTrace();
			fail();
		}

	}

	
	
	/**
	 * 実施単位１２＿３　承認処理（人事部承認）
	 */
	@Test
	public void unit12_3() {
		try{
			//準備
			unit12_2();
			accessClose();

			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID210101", "kazuko");
			sessionId = accessor.open();
			
			//ワークアイテムを取得
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPROVAL_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
			String wid = items[items.length-1].getID();

			//試験２　申請トランザクションテーブルの[状態]が"待ち"になっている最小の[承認ブロック番号]を取得する
			AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
			AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appId);
			AppTransaction appTrans = null;
			AppTransaction nextAppTrans = null;
			for (int i = 0; i < appTranses.length; i++) {
				String status = appTranses[i].getAppStatus();
				if ((StateConstants.STATUS_TRANS_WAIT).equals(status)) {
					appTrans = appTranses[i];
					if ( i < appTranses.length-1) {
						nextAppTrans = appTranses[i+1];
					}
					break;
				}
			}

			//試験３　申請書番号と取得した承認ブロック番号で申請トランザクションテーブルを更新
			if (appTrans != null) {
				appTrans.setAppStatus(StateConstants.STATUS_TRANS_APPROVE);
				appTrans.setAppUserID(usr.getID());
				appTrans.setComment("OK!");
				appTrans.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
				appTransDao.updateAppTransaction(appTrans);
			}

			//試験４　assignWorkItemAttribute
			// 申請トランザクションテーブルの更新した次のレコードの
			// [状態]を"WAIT"に更新
			int approveAccount = 4;
			if (nextAppTrans != null && nextAppTrans.getApproveAccountID() < approveAccount) {
				nextAppTrans.setAppStatus(StateConstants.STATUS_TRANS_WAIT);
				appTransDao.updateStatus(nextAppTrans);
			}

			// 作業項目のプロセス変数[承認結果]を"ACK"に設定
			VariableBean appResult = new VariableBean();
			appResult.setName(Constants.APPROVAL_RESULT);
			appResult.setValue(Constants.ACK);
			appResult.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appResult);

			// 最終承認者の場合、プロセス変数[状態]を"CONFIRM_WAIT"に更新
			int approveCount = 4;
			if (approveCount == appTrans.getApproveAccountID()+1) {
				VariableBean state = new VariableBean();
				state.setName(Constants.STATE);
				state.setValue(StateConstants.CONFIRM_WAIT);
				state.setType(1);
				wih.assignWorkItemAttribute(sessionId, wid, state);
			}

			//試験５　completeWorkItem
			wih.completeWorkItem(sessionId, wid);


			//確認１
			Thread.sleep(QUEUE_WAIT);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute appStateCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.STATE);
			assertEquals(StateConstants.CONFIRM_WAIT, appStateCheck.getValue());
			Attribute appResultCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.APPROVAL_RESULT);
			assertEquals(Constants.ACK, appResultCheck.getValue());

			//確認２
//			try{
//				wih.completeWorkItem(sessionId, wid);
//				fail();
//			} catch (InvalidWorkItemException e){
//				throw e;
//			}

		} catch (Exception e){
			e.printStackTrace();
			fail();
		}

	}
	
	
	/**
	 * 実施単位１３　否認
	 */
	@Test
	public void unit13() {
		try{
			//準備
			unit08();
			accessClose();
	
			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID110001", "jiro");
			sessionId = accessor.open();
			
			//ワークアイテムを取得
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.APPROVAL_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
			String wid = items[items.length-1].getID();
	
			//試験２　申請トランザクションテーブルの[状態]が"待ち"になっている最小の[承認ブロック番号]を取得する
			AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
			AppTransaction[] appTranses = appTransDao.getAppTransactionsByAppID(appId);
			AppTransaction appTrans = null;
			for (int i = 0; i < appTranses.length; i++) {
				String status = appTranses[i].getAppStatus();
				if ((StateConstants.STATUS_TRANS_WAIT).equals(status)) {
					appTrans = appTranses[i];
					break;
				}
			}
	
			//試験３　申請書番号と取得した承認ブロック番号で申請トランザクションテーブルを更新
			if (appTrans != null) {
				appTrans.setAppStatus(StateConstants.STATUS_TRANS_DENIAL);
				appTrans.setAppUserID(usr.getID());
				appTrans.setComment("could not approve!");
				appTrans.setDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
				appTransDao.updateAppTransaction(appTrans);
			}
	
			//試験４　assignWorkItemAttribute
			VariableBean appResult = new VariableBean();
			appResult.setName(Constants.APPROVAL_RESULT);
			appResult.setValue(Constants.NACK);
			appResult.setType(1);
			wih.assignWorkItemAttribute(sessionId, wid, appResult);
	
			//試験５　completeWorkItem
			wih.completeWorkItem(sessionId, wid);
	
	
			//確認１
			Thread.sleep(QUEUE_WAIT);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute appResultCheck = weh.getProcessAttributeValue(sessionId, pid, Constants.APPROVAL_RESULT);
			assertEquals(Constants.NACK, appResultCheck.getValue());
	
			//確認２
//			try{
//				wih.completeWorkItem(sessionId, wid);
//				fail();
//			} catch (InvalidWorkItemException e){
//				throw e;
//			}
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * 実施単位１４　同報申請一覧
	 */
	@Test
	public void unit14(){
		try{
			//準備
//			unit12_1();
//			unit12_2();
			unit12_3();
			
			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID200001", "yonko");
			sessionId = accessor.open();
						
			//試験２　getWorkItems
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.CONFIRM_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
		
			//試験３　getWorkItemAttributeValue
			boolean checkAppId = false;
			for (int i = 0; i < items.length; i++) {
				WorkItem item = items[i];
				String wid = item.getID();

				String appID = wih.getWorkItemAttributeValue(
						sessionId, wid, Constants.APPLICATION_NO).getValue();
				
				//確認１
				//確認２が正常に実行されることによって確認する。
				
				//確認２
				if (appId.equals(appID)){
					checkAppId = true;
				}
			}
			assertTrue(checkAppId);
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
		
	}
	
	
	/**
	 * 実施単位１５　同報確認
	 */
	@Test
	public void unit15() {
		try{
			//準備
			unit12_3();
			
			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID200001", "yonko");
			sessionId = accessor.open();
						
			//ワークアイテムを取得
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.CONFIRM_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
			String wid = items[items.length-1].getID();
			
			UserManager userManager = SingletonServices.getInstance().getUserManager();
			usr = userManager.getUser("UID200001");
			
			//試験２　getAttachedRoles
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role[] roles = roleManager.getAttachedRoles(usr);
			
			//試験３　assignWorkItemAttribute
			VariableBean confirmState = new VariableBean();
			confirmState.setType(3);        
            List list = new ArrayList();
            for (int i = 0; i < roles.length; i++) {
                list.add(roles[i].getID());
            }        
            if (list.contains("JINJI_KACHO_ROLE")) {
            	confirmState.setName("NOTIFICATION_JINJI_KACHO");
            } else if (list.contains("JINJI_BUCHO_ROLE")) {
            	confirmState.setName("NOTIFICATION_JINJI_BUCHO");
            }        
            confirmState.setValue("true");
            wih.assignWorkItemAttribute(sessionId, wid, confirmState);
            
			//試験４　completeWorkItem
			wih.completeWorkItem(sessionId, wid);
			
			//確認１
			Set<String> roleSet = new HashSet<String>();
			roleSet.add("JINJI_ROLE");
			roleSet.add("BUCHO_ROLE");
			roleSet.add("JINJI_BUCHO_ROLE");

			for (int i=0; i < roles.length; i++){
				String tempRole = roles[i].getID();
				System.out.println(tempRole);
				assertTrue(roleSet.contains(tempRole));
			}
			assertEquals(roles.length, 3);
			
			//確認２
			Thread.sleep(QUEUE_WAIT);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute confirmStateCheck = weh.getProcessAttributeValue(
					sessionId, pid, "NOTIFICATION_JINJI_BUCHO");
			assertEquals(confirmStateCheck.getValue(), "true");

			//課長でも確認してプロセスを終わらせる
			unit15_2();
			
			//確認３
//			try{
//				wih.completeWorkItem(sessionId, wid);
//				fail();
//			} catch (InvalidWorkItemException e){
//				throw e;
//			}
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * 実施単位１５_2　同報確認(課長)
	 */
	public void unit15_2() {
		try{
			//準備
//			unit12_3();
			
			//試験１　ログイン
			accessor = SingletonServices.getInstance().getAccessor("UID210001", "sanko");
			sessionId = accessor.open();
						
			//ワークアイテムを取得
			WorkItemHandler wih = accessor.getWorkItemHandler();
			AttributeFilter stateFilter = new AttributeFilter(
					Constants.STATE, 1, StateConstants.CONFIRM_WAIT);
			WorkItem[] items = wih.getWorkItems(sessionId, stateFilter);
			String wid = items[items.length-1].getID();
			
			UserManager userManager = SingletonServices.getInstance().getUserManager();
			usr = userManager.getUser("UID210001");
			
			//試験２　getAttachedRoles
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role[] roles = roleManager.getAttachedRoles(usr);
			
			//試験３　assignWorkItemAttribute
			VariableBean confirmState = new VariableBean();
			confirmState.setType(3);        
            List list = new ArrayList();
            for (int i = 0; i < roles.length; i++) {
                list.add(roles[i].getID());
            }        
            if (list.contains("JINJI_KACHO_ROLE")) {
            	confirmState.setName("NOTIFICATION_JINJI_KACHO");
            } else if (list.contains("JINJI_BUCHO_ROLE")) {
            	confirmState.setName("NOTIFICATION_JINJI_BUCHO");
            }        
            confirmState.setValue("true");
            wih.assignWorkItemAttribute(sessionId, wid, confirmState);
            
			//試験４　completeWorkItem
			wih.completeWorkItem(sessionId, wid);
			
			//確認１
			Set<String> roleSet = new HashSet<String>();
			roleSet.add("JINJI_ROLE");
			roleSet.add("KACHO_ROLE");
			roleSet.add("JINJI_KACHO_ROLE");

			for (int i=0; i < roles.length; i++){
				String tempRole = roles[i].getID();
				System.out.println(tempRole);
				assertTrue(roleSet.contains(tempRole));
			}
			assertEquals(roles.length, 3);
			
			//確認２
			Thread.sleep(QUEUE_WAIT);
			WorkflowEngineHandler weh = accessor.getWorkflowEngineHandler();
			Attribute confirmStateCheck = weh.getProcessAttributeValue(
					sessionId, pid, "NOTIFICATION_JINJI_KACHO");
			assertEquals(confirmStateCheck.getValue(), "true");
			
			//確認３
//			try{
//				wih.completeWorkItem(sessionId, wid);
//				fail();
//			} catch (InvalidWorkItemException e){
//				throw e;
//			}
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	/**
	 * 実施単位９で使用。
	 * リストに含まれていない申請書番号を追加して返す。
	 * @param list　申請書番号のリスト
	 * @param appts　申請トランザクション
	 * @throws Exception　任意の例外
	 */
	private void addAppID(List list, AppTransaction[] appts) throws Exception {
		for (int i = 0; i < appts.length; i++) {
			String id = appts[i].getAppID();
			AppTransactionDAO appTransDao = DAOFactory.getAppTransactionDAO();
			AppTransaction appTrans = appTransDao.getAppTransactionByAppIDBlockID(id, 0);            
			if (!list.contains(id) && (StateConstants.STATUS_TRANS_APPLY).equals(appTrans.getAppStatus())) {
				list.add(id);
			}
		}
	}
	
	


	/**
	 * 開いたAccessorを閉じる。
	 */
	@After
	public void accessClose(){
		try {
			if (accessor != null){
				accessor.close();
			}
		} catch (InvalidSessionException e) {
			fail();
		}
	}
}
