package jp.co.argo21.nautica.ejbtest;
import java.io.IOException;

import javax.naming.NamingException;

import jp.co.argo21.nautica.workflow.client.ConnectionInfo;
import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.GeronimoUtils;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;


public class SingletonServices {

	private static UserManager userManager;
	private static OrganizationManager orgManager;
	private static RoleManager roleManager;    
	private static WorkItemHandler wih;    
	private static WorkflowEngineHandler weh;
	private static WorkflowServiceAccessor accessor;

	private static final SingletonServices singleton = new SingletonServices();

	/**
	 * コンストラクタ
	 * @throws NamingException 
	 * 
	 * @throws IOException
	 */
	private SingletonServices(){}

	/**
	 * このクラスのインスタンスを返す。
	 * 
	 * @return インスタンス
	 */
	public static SingletonServices getInstance() {	
		return singleton;
	}

	public UserManager getUserManager() throws NamingException{
		userManager = (UserManager)GeronimoUtils.getEJB(
				"ejbd://127.0.0.1:4201", 
		"nautica-workflow/UserManagerBean/jp.co.argo21.nautica.workflow.security.UserManager");
		return userManager;
	}
	
	public OrganizationManager getOrganizationManager() throws NamingException{
		orgManager = (OrganizationManager)GeronimoUtils.getEJB(
				"ejbd://127.0.0.1:4201", 
		"nautica-workflow/OrganizationManagerBean/jp.co.argo21.nautica.workflow.security.OrganizationManager");
		return orgManager;
	}
	
	public RoleManager getRoleManager() throws NamingException{
		roleManager = (RoleManager)GeronimoUtils.getEJB(
				"ejbd://127.0.0.1:4201", 
		"nautica-workflow/RoleManagerBean/jp.co.argo21.nautica.workflow.security.RoleManager");
		return roleManager;
	}
	
	public WorkflowServiceAccessor getAccessor(String uId, String passwd){
		ConnectionInfo ci = new ConnectionInfo("ejbd://127.0.0.1:4201", "engine001", uId, passwd);
		WorkflowServiceAccessor accessor = new WorkflowServiceAccessor(ci);
		return accessor;
	}
	
	public WorkItemHandler getWfWorkitemHandler() throws InvalidSessionException{
		return accessor.getWorkItemHandler();
	}
	public WorkflowEngineHandler getWfEngineHandler() throws InvalidSessionException{
		return accessor.getWorkflowEngineHandler();
	}
	
//	private String getNauticaWorkflowConfig(String key){}
	
	public String getProcessDefID(String key){
		return "Overtime-0";
	}
}
