package jp.co.argo21.nautica.ejbtest;

import static org.junit.Assert.*;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;

import org.junit.Test;

public class OrgRoleTest {
	
	@Test
	public void unit01_1(){
		try{
			//試験手順
			OrganizationManager orgManager = SingletonServices.getInstance().getOrganizationManager();
			Organization org = orgManager.getOrganization("E110");
			
			//確認
			assertEquals(org.getName(), "企画営業部一課");
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	
	@Test
	public void unit1_2(){
		try{
			//試験手順
			OrganizationManager orgManager = SingletonServices.getInstance().getOrganizationManager();
			Organization org = orgManager.getOrganization("E110");
			User[] users = orgManager.getAssignedUser(org);
			
			//確認
			assertEquals(users[0].getID(), "UID110001");
		}catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	
	@Test
	public void unit1_3(){
		try{
			//試験手順
			OrganizationManager orgManager = SingletonServices.getInstance().getOrganizationManager();
			Organization org = orgManager.getOrganization("E110");
			Organization highOrg = orgManager.getHigherOrganization(org);
			
			//確認
			assertEquals(highOrg.getName(), "企画営業部");
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	
	@Test
	public void unit2_1(){
		try{
			//試験手順
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role role = roleManager.getRole("EMPLOYEE_ROLE");
			
			//確認
			assertEquals(role.getName(), "一般社員ロール");
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	
	@Test
	public void unit2_2(){
		try{
			//試験手順
			OrganizationManager orgManager = SingletonServices.getInstance().getOrganizationManager();
			Organization org = orgManager.getOrganization("J100");
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role[] role = roleManager.getAttachedRoles(org);
			
			//確認
			assertEquals(role[0].getName(), "人事部ロール");
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	
	@Test
	public void unit2_3(){
		try{
			//試験手順
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role role = roleManager.getRole("KIKAKU_ROLE");
			Organization[] orgs = roleManager.getOrganizationsByRole(role);
			
			
			//確認
			assertEquals(orgs[0].getName(), "企画営業部");
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	
	@Test
	public void unit2_4(){
		try{
			//試験手順
			RoleManager roleManager = SingletonServices.getInstance().getRoleManager();
			Role role = roleManager.getRole("JINJI_BUCHO_ROLE");
			User[] users = roleManager.getUsersByRole(role);
			
			//確認
			assertEquals(users[0].getID(), "UID200001");
		} catch (Exception e){
			e.printStackTrace();
			fail();
		}
	}
}
