package jp.co.argo21.nautica.ejbtest;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import org.junit.After;
import org.junit.Test;

import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessor;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.engine.RepositoryLoader;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.InvalidUserException;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.wfmc.Activity;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.ConnectionFailedException;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidActivityNameException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessInstanceException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSourceUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidTargetUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.Process;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;

public class EJBModuleTest
{
	//private static final String WORKFLOW_DEFINITION	= "Overtime";					//ワークフロー定義名
	private static final String PROCESS_DEF_NAME		= "APPLY";					//プロセス定義名
	//private static final String PROCESS_DEF_ID		= "PS111804527481200000";	//プロセス定義名”APPLY”の定義ID
	private static final String PROCESS_DEF_ID		= "Overtime-0";				//プロセス定義名”APPLY”の定義ID
	private static final String ACTIVITY_DEF_ID		= "AC111804527485900000";	//アクティビティ定義名”START_APPLY”の定義ID
	private static final String WORKFLOW_RELATIVE_PATH 	= "Overtime.xpdl";		//ワークフロー定義名”Overtime”の相対パス
	private static final String WORKFLOW_ABSOLUTE_PATH	="/home/knakata/project_G/Geronimo/geronimo-tomcat6-jee5-2.0.1/var/nautica/repository/Overtime.xpdl"; 
	private static final String LOGIN_USER_ID 		= "UID110101";
	private static final String PASSWORD 				= "taro";
	private static final String ADMIN_PASSWORD		= "admin";
	private static final String PROCESS_TEST_NAME	= "TEST";						//プロセスインスタンスの名前
	private static final String ATTRIBUTE_TEST_NAME	= "testAttribute";			//インスタンス属性の名前
	private static final String ATTRIBUTE_NAME		= "APPLICANT_ID";
	//private static final String ACTIVITY_TEST_NAME	= "testActivity";
	//private static final String ACTIVITY_NAME			= "START_APPLY";
	private static final String ROLE_ID				= "EMPLOYEE_ROLE";
	private static final int OPEN_NOT_RUNNING_NOT_STARTED = 1;
	private static final int OPEN_NOT_RUNNING_SUSPENDED	= 2;
	private static final int OPEN_RUNNING				= 3;
	//private static final int CLOSED_COMPLETED			= 4;
	//private static final int CLOSED_TERMINATED		= 5;
	private WorkflowServiceAccessor accessor			= null;
	private DefinitionRepository defRepository		= null;
	private RepositoryLoader repLoader					= null;
	private WorkflowEngineHandler wfEngine			= null;
	private WorkflowAdminHandler wfAdmin				= null;
	private WorkItemHandler wfItem						= null;
	private UserManager usrManager						= null;
	private String sessionId							= null;						//セッションID
	private String pId									= null;						//プロセスインスタンスID
	private String actId									= null;						//アクティビティインスタンスID
	private WorkItem item								= null;
	private WorkItemState[] itemState					= null;
	private ProcessDefinitionState[] pdState			= null;
	
	
	/**
	 * 実施単位１：ワークフロー定義の登録および取得
	 */
	@Test
	public void unit01()
	{
		//準備作業１
		connectWorkflow(LOGIN_USER_ID, PASSWORD);
		
		defRepository = BeanSingleton.getInstance().getDefRepository();
		ProcDef[] procDef = null;
		try
		{
			//試験手順１
			//TODO(registerDefinitionメソッドの引数が、マニュアルと違う-> <WORKFLOW_DEFINITION>ではなく<PROCESS_DEF_ID>)
			//defRepository.registerDefinition(sessionId, PROCESS_DEF_ID, WORKFLOW_RELATIVE_PATH);
			//試験手順２
			//TODO(NameFilterには、名前ではなくプロセス定義IDを入れる)
			Filter filter = new NameFilter(PROCESS_DEF_ID, Filter.EQUAL);
			procDef = defRepository.getProcessDefinitions(sessionId, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (WorkflowException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		assertTrue(procDef.length != 0);
		//確認作業１
		assertEquals(procDef[0].getName(), PROCESS_DEF_NAME);
		//確認作業２
		assertEquals(procDef[0].getID(), PROCESS_DEF_ID);
		
		System.out.println("procDef[0].getName()-> " + procDef[0].getName());
		System.out.println("procDef[0].getID()-> " + procDef[0].getID());
	}
	
	/**
	 * 実施単位２ー１：プロセス定義の状態遷移（遷移可能状態の取得）
	 */
	@Test
	public void unit02_1()
	{
		//準備作業１
		unit01();
		
		//試験手順１
		try
		{
			pdState = defRepository.getProcessDefinitionStates(sessionId, PROCESS_DEF_ID);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		
		//確認作業１
		
		assertNotNull(pdState);
		System.out.println("実施単位２：遷移可能状態");
		for (ProcessDefinitionState transitionState : pdState)
		{
			System.out.println("\t" + transitionState);
		}
		
	}
	
	/**
	 * 実施単位２ー２：プロセス定義の状態遷移（状態の遷移）
	 */
	@Test
	public void unit02_2()
	{
		//準備作業１
		unit01();
		//準備作業２
		unit02_1();
		
		ProcDef[] procDef = null;
		try
		{
			//試験手順１
			defRepository.changeProcessDefinitionState(sessionId, PROCESS_DEF_ID, pdState[0]);
			//試験手順２
			Filter filter = new NameFilter(PROCESS_DEF_ID, Filter.EQUAL);
			procDef = defRepository.getProcessDefinitions(sessionId, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
			
		}
		
		//確認作業１
		assertNotNull(procDef);
		assertEquals(procDef[0].getState(), pdState[0]);
	}
	
	/**
	 * 実施単位３ー１：ワークフロー定義ファイルの読み出し（定義ファイルの読み出し）
	 */
	@Test
	public void unit03_1()
	{
		//準備作業１
		unit01();
		
		repLoader = BeanSingleton.getInstance().getRepLoader();
		String loaderContent = null;
		String xpdlContent = null;
		try
		{
			//試験手順１
			loaderContent = repLoader.getDefinition(sessionId, ADMIN_PASSWORD,  WORKFLOW_RELATIVE_PATH);
			//確認作業１のための準備
			xpdlContent = getFileContent();
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(loaderContent, xpdlContent);
	}
	
	/**
	 * 実施単位３ー２：ワークフロー定義ファイルの読み出し（プロセス定義を記述している定義ファイルのパスの取得）
	 */
	@Test
	public void unit03_2()
	{
		//準備作業１
		unit01();
		
		repLoader = BeanSingleton.getInstance().getRepLoader();
		String xpdlPath = null;
		try
		{
			//試験手順１
			//TODO(マニュアルの引数間違い-> <プロセス定義名>ではなく<プロセス定義ID>)
			xpdlPath = repLoader.getDefinitionPath(sessionId, PROCESS_DEF_ID);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(xpdlPath, WORKFLOW_RELATIVE_PATH);
	}
	
	/**
	 * 実施単位４ー１：プロセスインスタンスの制御（プロセスインスタンスの停止）
	 */
	@Test
	public void unit04_1()
	{
		//準備作業
		readyProcess();
		
		ProcessState pState = ProcessState.getState(OPEN_RUNNING);
		try
		{
			//TODO(startProcessメソッドが完成するまでのしのぎ)
			wfEngine.changeProcessState(sessionId, pId, pState);
			//試験手順１
			wfEngine.terminateProcess(sessionId, pId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
	}
	
	/**
	 * 実施単位４ー２：プロセスインスタンスの制御（プロセスインスタンスの遷移可能状態の取得）
	 */
	@Test
	public void unit04_2()
	{
		//準備作業
		readyProcess();
		
		ProcessState[] pState = null;
		try
		{
			//試験手順１
			Filter filter = null;
			pState = wfEngine.getProcessStates(sessionId, pId, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		System.out.println("実施単位４ー２：プロセスインスタンス利用可能状態の取得");
		for (ProcessState transitionState : pState )
		{
			System.out.println("\t" + transitionState);
		}
	}
	
	/**
	 * 実施単位４ー３：プロセスインスタンスの制御（プロセスインスタンスの状態の変更）
	 */
	@Test
	public void unit04_3()
	{
		//準備作業
		readyProcess();
		
		Process process = null;
		//ProcessState pState = ProcessState.getState(CLOSED_COMPLETED);
		ProcessState pState = ProcessState.getState(OPEN_RUNNING);
		try
		{
			//試験手順１
			wfEngine.changeProcessState(sessionId, pId, pState);
			//試験手順２
			process = wfEngine.getProcess(sessionId, pId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(process.getProcessState(), pState.toInt());
	}
	
	/**
	 * 実施単位５ー１：プロセスインスタンス属性の取得（プロセスインスタンス属性一覧の取得）
	 */
	@Test
	public void unit05_1()
	{
		//準備作業１〜３
		readyProcess();
		
		Attribute[] attribute = null;
		VariableBean variable = new VariableBean();
		variable.setName(ATTRIBUTE_TEST_NAME);
		try
		{
			//準備作業４
			wfEngine.assignProcessAttribute(sessionId, pId, variable);
			
			//試験手順１
			Filter filter = new NameFilter(ATTRIBUTE_TEST_NAME, Filter.EQUAL);
			attribute = wfEngine.getProcessAttributes(sessionId, pId, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidAttributeException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (AttributeAssignmentFailedException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(attribute[0].getName(), ATTRIBUTE_TEST_NAME);
	}
	
	/**
	 * 実施単位５ー２：プロセスインスタンス属性の取得（プロセスインスタンス属性の取得）
	 */
	@Test
	public void unit05_2()
	{
		//準備作業１〜３
		readyProcess();
		
		Attribute attribute = null;
		try
		{
			//準備作業４
			VariableBean variable = new VariableBean();
			variable.setName(ATTRIBUTE_TEST_NAME);
			wfEngine.assignProcessAttribute(sessionId, pId, variable);
			
			//試験手順１
			attribute = wfEngine.getProcessAttributeValue(sessionId, pId, ATTRIBUTE_TEST_NAME);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidAttributeException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (AttributeAssignmentFailedException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(attribute.getName(), ATTRIBUTE_TEST_NAME);
	}
	
	/**
	 * 実施単位６ー１：アクティビティインスタンスの取得（アクティビティインスタンス一覧の取得）
	 */
	@Test
	public void unit06_1()
	{
		//準備作業
		readyProcess();
		
		Activity[] activity = null;
		ProcessState pState = ProcessState.getState(OPEN_RUNNING);
		try
		{
			//TODO(startProcessメソッドが完成するまでのしのぎ)
			wfEngine.changeProcessState(sessionId, pId, pState);
			//試験手順１
			Filter filter = new StateFilter(ProcessState.getState(OPEN_NOT_RUNNING_NOT_STARTED));
			activity = wfEngine.getActivities(sessionId, pId, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
		}
		finally
		{
		}
		
		assertTrue(activity.length != 0);
		//確認作業１
		assertEquals(activity[0].getActivityDefinitionID(), ACTIVITY_DEF_ID);
		//他の実施単位のための準備作業
		actId = activity[0].getActivityID();
	}
	
	/**
	 * 実施単位６ー２：アクティビティインスタンスの取得（アクティビティインスタンスの取得）
	 */
	@Test
	public void unit06_2()
	{
		//準備作業１〜４
		unit06_1();
		
		Activity activity = null;
		try
		{
			activity = wfEngine.getActivity(sessionId, pId, actId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(activity.getActivityDefinitionID(), ACTIVITY_DEF_ID);
	}
	
	/**
	 * 実施単位７ー１：アクティビティの状態遷移（アクティビティインスタンスの遷移可能状態の取得）
	 */
	@Test
	public void unit07_1()
	{
		//準備作業１〜４
		unit06_1();
		
		ActivityState[] actState = null;
		try
		{
			//試験手順１
			Filter filter = null;
			actState = wfEngine.getActivityStates(sessionId, pId, actId, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		 
		 //確認作業１
		System.out.println("実施単位７ー１：アクティビティインスタンスの遷移可能状態");
		for (ActivityState transitionState : actState )
		{
			System.out.println("\t" + transitionState);
		}
	}
	 
	/**
	 * 実施単位７ー２：アクティビティの状態遷移（アクティビティインスタンス状態の変更）
	 */
	@Test
	public void unit07_2()
	{
		//準備作業１〜４
		unit06_1();
		
		Activity activity = null;
		ActivityState actState = ActivityState.getState(OPEN_RUNNING);
		try
		{
			//試験手順１
			wfEngine.changeActivityState(sessionId, pId, actId, actState);
			//確認作業１のための準備
			activity = wfEngine.getActivity(sessionId, pId, actId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(activity.getActivityState(), actState.toInt());
	}
	
	/**
	 * 実施単位８ー１：アクティビティ属性の操作（アクティビティインスタンス属性一覧の取得）
	 */
	@Test
	public void unit08_1()
	{
		//準備作業１〜４
		unit06_1();
		
		Attribute[] attribute = null;
		try
		{
			//試験手順１
			Filter filter = null;
			attribute = wfEngine.getActivityAttributes(sessionId, pId, actId, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		assertTrue(attribute.length != 0);
		//確認作業１
		Boolean checkFlag = null;
		for (Attribute transitionAttr : attribute)
		{
			checkFlag = false;
			String compareName = transitionAttr.getName();
			if ("APPLICANT_ID".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("APPLICANT_NAME".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("ORGANIZATION_CODE".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("APPLICATION_TYPE_CODE".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("APPLICATION_TYPE_NAME".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("APPLICATION_NO".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("APPLY_DATE".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("APPROVAL_RESULT".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("APPROVAL_BLOCK_CODE".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("STATUS".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("NOTIFICATION_JINJI_BUCHO".equals(compareName))
			{
				checkFlag = true;
			}
			else if ("NOTIFICATION_JINJI_KACHO".equals(compareName))
			{
				checkFlag = true;
			}
			
			if (checkFlag == false)
			{
				break;
			}
		}
		assertTrue(checkFlag);
	}
	
	/**
	 * 実施単位８ー２：アクティビティ属性の操作（アクティビティインスタンス属性の取得）
	 */
	@Test
	public void unit08_2()
	{
		//準備作業１〜４
		unit06_1();
		
		Attribute attribute = null;
		try
		{
			//試験手順１
			attribute = wfEngine.getActivityAttributeValue(sessionId, pId, actId, ATTRIBUTE_NAME);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidAttributeException e)
		{
			e.printStackTrace();
			fail();
		}
		
		//確認作業１
		assertEquals(attribute.getName(), ATTRIBUTE_NAME);
	}
	
	/**
	 * 実施単位８ー３：アクティビティ属性の操作（アクティビティインスタンス属性の割り当て）
	 */
	@Test
	public void unit08_3()
	{
		//準備作業１〜４
		unit06_1();
		
		Attribute attribute = null;
		try
		{
			//試験手順１
			VariableBean variable = new VariableBean();
			variable.setName(ATTRIBUTE_TEST_NAME);
			wfEngine.assignActivityAttribute(sessionId, pId, actId, variable);
			//試験手順２
			attribute = wfEngine.getActivityAttributeValue(sessionId, pId, actId, ATTRIBUTE_TEST_NAME);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidAttributeException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (AttributeAssignmentFailedException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(attribute.getName(), ATTRIBUTE_TEST_NAME);
	}
	
	/**
	 * 実施単位９ー１：プロセスインスタンスの管理（プロセス定義に属するプロセスインスタンスの状態の変更）
	 */
	@Test
	public void unit09_1()
	{
		//準備作業
		readyProcess();
		
		wfAdmin = BeanSingleton.getInstance().getWfAdmin();
		Process process = null;
		ProcessState pState = ProcessState.getState(OPEN_RUNNING);
		try
		{
			//試験手順１
			Filter filter = new StateFilter(ProcessState.getState(OPEN_NOT_RUNNING_NOT_STARTED));
			wfAdmin.changeProcessesState(sessionId, PROCESS_DEF_ID, filter, pState);
			//試験手順２
			process = wfEngine.getProcess(sessionId, pId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(process.getProcessState(), pState.toInt());
	}
	
	/**
	 * 実施単位９ー２：プロセスインスタンスの管理（プロセス定義に属するプロセスインスタンスの中断）
	 */
	@Test
	public void unit09_2()
	{
		//準備作業
		readyProcess();
		
		wfAdmin = BeanSingleton.getInstance().getWfAdmin();
		try
		{
			//試験手順１
			Filter filter = new NameFilter(PROCESS_TEST_NAME, Filter.EQUAL);
			wfAdmin.terminateProcesses(sessionId, PROCESS_DEF_ID, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		//ワークフローエンジンのログにプロセス中断のログが出力されるか確認する。
	}
	
	/**
	 * 実施単位９ー３：プロセスインスタンスの管理（プロセス定義に属するプロセスインスタンスの中止）
	 */
	@Test
	public void unit09_3()
	{
		//準備作業
		readyProcess();
		
		wfAdmin = BeanSingleton.getInstance().getWfAdmin();
		try
		{
			//試験手順１
			Filter filter = new NameFilter(PROCESS_TEST_NAME, Filter.EQUAL);
			wfAdmin.abortProcesses(sessionId, PROCESS_DEF_ID, filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業
		//ワークフローエンジンのログにプロセス中止のログが出力されるか確認する。
	}
	
	/**
	 * 実施単位９ー４：プロセスインスタンスの管理（プロセスインスタンスの中止）
	 */
	@Test
	public void unit09_4()
	{
		//準備作業
		readyProcess();
		
		wfAdmin = BeanSingleton.getInstance().getWfAdmin();
		try
		{
			//試験手順１
			wfAdmin.abortProcess(sessionId, pId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		
		//確認作業１
		//ワークフローエンジンのログにプロセス中止のログが出力されるか確認する。
	}
	
	/**
	 * 実施単位１０：アクティビティインスタンスの状態管理
	 */
	@Test
	public void unit10()
	{
		//準備作業
		unit06_1();
		
		wfAdmin = BeanSingleton.getInstance().getWfAdmin();
		Activity activity = null;
		ActivityState actState = ActivityState.getState(OPEN_RUNNING);
		try
		{
			//試験手順１
			Filter filter = new StateFilter(ProcessState.getState(OPEN_NOT_RUNNING_NOT_STARTED));
			wfAdmin.changeActivitiesState(sessionId, PROCESS_DEF_ID, ACTIVITY_DEF_ID, filter, actState);
			//試験手順２
			activity = wfEngine.getActivity(sessionId, pId, actId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityNameException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityInstanceException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(activity.getActivityState(), actState.toInt());
	}
	
	/**
	 * 実施単位１１：プロセス属性の管理
	 */
	@Test
	public void unit11()
	{
		//準備作業
		readyProcess();
		
		wfAdmin = BeanSingleton.getInstance().getWfAdmin();
		Attribute attribute = null;
		try
		{
			//試験手順１
			Filter filter = new NameFilter(PROCESS_TEST_NAME,Filter.EQUAL);
			VariableBean variable = new VariableBean();
			variable.setName(ATTRIBUTE_TEST_NAME);
			wfAdmin.assignProcessesAttribute(sessionId, PROCESS_DEF_ID, filter, variable);
			//試験手順２
			attribute = wfEngine.getProcessAttributeValue(sessionId, pId, ATTRIBUTE_TEST_NAME);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidAttributeException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(attribute.getName(), ATTRIBUTE_TEST_NAME);
	}
	
	/**
	 * 実施単位１２：アクティビティ属性の管理
	 */
	@Test
	public void unit12()
	{
		//準備作業１〜３
		readyProcess();
		//準備作業４
		unit06_1();
		
		wfAdmin = BeanSingleton.getInstance().getWfAdmin();
		Attribute attribute = null;
		try
		{
			//試験手順１
			Filter filter = new StateFilter(ProcessState.getState(OPEN_NOT_RUNNING_NOT_STARTED));
			VariableBean variable = new VariableBean();
			variable.setName(ATTRIBUTE_TEST_NAME);
			wfAdmin.assignActivitiesAttribute(sessionId, PROCESS_DEF_ID, ACTIVITY_DEF_ID, filter, variable);
			//試験手順２
			attribute = wfEngine.getActivityAttributeValue(sessionId, pId, actId, ATTRIBUTE_TEST_NAME);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidActivityNameException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidAttributeException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertEquals(attribute.getName(), ATTRIBUTE_TEST_NAME);
	}
	
	/**
	 * 実施単位１３ー１：作業項目の状態遷移（作業項目の遷移可能な状態一覧の取得）
	 */
	@Test
	public void unit13_1()
	{
		//準備作業１〜３
		readyProcess();
		
		//プロセスインスタンスが登録されるのを待つための処理
		sleep();
		
		wfItem = BeanSingleton.getInstance().getWfItem();
		try
		{
			//準備作業４
			Filter filter = null;
			WorkItem[] item = wfItem.getWorkItems(sessionId, filter);
			assertTrue(item.length != 0);
			this.item = item[item.length-1];
			//WorkItemの情報表示
			System.out.println("Work Item num -> " + item.length);
			System.out.println("Work Item name -> " + this.item.getName());
			//試験手順１
			itemState = wfItem.getWorkItemStates(sessionId, this.item.getID(), filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidWorkItemException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertNotNull(itemState);
		System.out.println("実施単位１３ー１：作業項目の遷移可能な状態一覧の取得");
		for (WorkItemState transitionState : itemState )
		{
			System.out.println("\t" + transitionState.toString());
		}
	}
	
	/**
	 * 実施単位１３ー２：作業項目の状態遷移（作業項目状態の変更）
	 */
	@Test
	public void unit13_2()
	{
		//準備作業１〜５
		unit13_1();
		
		WorkItemState itemState = WorkItemState.getState(OPEN_NOT_RUNNING_SUSPENDED);
		WorkItemState[] checkState = null;
		try
		{
			//試験手順１
			wfItem.changeWorkItemState(sessionId, item.getID(), itemState);
			//試験手順２
			Filter filter = null;
			checkState = wfItem.getWorkItemStates(sessionId, item.getID(), filter);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidWorkItemException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidStateException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (TransitionNotAllowedException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
		//確認作業１
		assertNotNull(checkState);
		System.out.println("実施単位１３ー２：作業項目状態の変更");
		for (WorkItemState transitionState : checkState )
		{
			System.out.println("\t" + transitionState.toString());
		}
	}
	
	/**
	 * 実施単位１４：作業項目の再割り当て
	 */
	@Test
	public void unit14()
	{
		//準備作業１〜３
		readyProcess();
		//プロセスインスタンスが登録されるのを待つための処理
		sleep();
		
		wfItem = BeanSingleton.getInstance().getWfItem();
		usrManager = BeanSingleton.getInstance().getUsrManager();
		Participant beforeRole = null;
		Participant afterUsr = null;
		try
		{
			//準備作業４
			Filter filter = null;
			WorkItem[] item = wfItem.getWorkItems(sessionId, filter);
			assertTrue(item.length != 0);
			this.item = item[item.length-1];
			
			//試験手順１
			RoleManager roleManager = BeanSingleton.getInstance().getRoleManager();
			beforeRole = roleManager.getRole(ROLE_ID);
			assertNotNull(beforeRole);
			//試験手順２
			afterUsr = usrManager.getUser("UID120101");  //afterUsr = roleManager.getRole("KACHO_ROLE");
			assertNotNull(afterUsr);
			//試験手順３
			wfItem.reassignWorkItem(sessionId, beforeRole, afterUsr, this.item.getID());
			sleep();
			//試験手順４
			accessClose();
			connectWorkflow("UID120101", "kazuo");
			//試験手順５
			this.item = wfItem.getWorkItem(sessionId, this.item.getID());
			
			//確認作業１
			assertEquals(this.item.getParticipantName(), afterUsr.getID());
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidFilterException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidUserException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (WorkflowSecurityException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidWorkItemException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidSourceUserException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (InvalidTargetUserException e)
		{
			e.printStackTrace();
			fail();
		}
		catch (WorkflowException e)
		{
			e.printStackTrace();
			fail();
		}
		finally
		{
		}
		
	}
	
	/**
	 * ワークフローに接続し、セッションIDを取得する。
	 */
	public void connectWorkflow(String uid, String passwd)
	{
		accessor = SingletonServices.getInstance().getAccessor(uid, passwd);
		//accessor = SingletonServices.getInstance().getAccessor("admin", "admin");
		//accessor = SingletonServices.getInstance().getAccessor("UID120101", "kazuo");
		try
		{
			sessionId = accessor.open();
			System.out.println("session ID: " + sessionId);
		}
		catch (ConnectionFailedException e)
		{
			e.printStackTrace();
		}
		finally
		{
		}
	}
	
	/**
	 * ファイルの内容を出力する
	 * @return ファイルの内容を保持したStringインスタンス
	 */
	public String getFileContent()
	{
		BufferedReader reader = null;
		StringBuffer content = new StringBuffer();
		String lineSeparator = System.getProperty("line.separator");
		try
		{
			reader = new BufferedReader(new FileReader(WORKFLOW_ABSOLUTE_PATH));
			while (reader.ready())
			{
				content.append(reader.readLine()).append(lineSeparator);
			}
		}
		catch (FileNotFoundException e)
		{
			e.printStackTrace();
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (reader != null)
			{
				try
				{
					reader.close();
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
			}
		}
		
		return content.toString();
	}
	
	/**
	 * プロセスインスタンスの生成と開始の準備作業をする。
	 */
	public void readyProcess()
	{
		//準備作業１
		unit01();
		
		wfEngine = BeanSingleton.getInstance().getWfEngine();
		try
		{
			//準備作業２
			pId = wfEngine.createProcess(sessionId, PROCESS_DEF_ID, PROCESS_TEST_NAME);
			System.out.println("Process Instance ID-> " + pId);
			//準備作業３
			wfEngine.startProcess(sessionId, pId);
		}
		catch (InvalidSessionException e)
		{
			e.printStackTrace();
		}
		catch (InvalidProcessDefinitionException e)
		{
			e.printStackTrace();
		}
		catch (InvalidProcessInstanceException e)
		{
			e.printStackTrace();
		}
		catch (InvalidAttributeException e)
		{
			e.printStackTrace();
		}
		finally
		{
		}
	}
	
	/**
	 * 処理を待機させる。
	 */
	public void sleep()
	{
		try
		{
			Thread.sleep(20000);
		}
		catch (InterruptedException e1)
		{
			e1.printStackTrace();
		}
	}
	
	/**
	 * ワークフローとの接続を切る。
	 */
	@After
	public void accessClose()
	{
		if (accessor != null)
		{
			try
			{
				accessor.close();
			}
			catch (InvalidSessionException e)
			{
				e.printStackTrace();
			}
		}
	}
}
