package jp.co.argo21.nautica.ejbtest;

import javax.naming.NamingException;

import jp.co.argo21.nautica.workflow.engine.RepositoryLoader;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.GeronimoUtils;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager;

public class BeanSingleton
{
	private static BeanSingleton singleton = new BeanSingleton();
	
	private DefinitionRepository defRepository;
	private RepositoryLoader repLoader;
	private WorkflowAdminHandler wfAdmin;
	private WorkflowEngineHandler wfEngine;
	private WorkflowServiceManager wfService;
	private WorkItemHandler wfItem;
	private UserManager usrManager;
	private RoleManager roleManager;
	
	private String NAUTICA_EJB_PATH = "ejbd://127.0.0.1:4201";
	
	/**
	 * コンストラクタ
	 */
	private BeanSingleton()
	{
		try
		{
			setDefRepository();
			setWfServiceManager();
			setRepLoader();
			setWfEngine();
			setWfAdmin();
			setWfItem();
			setUsrManager();
			setRoleManager();
		}
		catch (NamingException e)
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * BeanSingletonクラスのインスタンスを返す。
	 * @return BeanSingletonクラスのインスタンス
	 */
	public static BeanSingleton getInstance()
	{
		return singleton;
	}
	
	/**
	 * WorkflowServiceManagerクラスのインスタンスをセットする。
	 * @throws NamingException 
	 */
	private void setWfServiceManager() throws NamingException
	{
		wfService = (WorkflowServiceManager)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/WorkflowServiceManagerBean/jp.co.argo21.nautica.workflow.wfmc.WorkflowServiceManager");
	}
	
	/**
	 * WorkflowServiceManagerクラスのインスタンスを返す。
	 * @return
	 */
	public WorkflowServiceManager getWfServiceManager()
	{
		return wfService;
	}
	
	/**
	 * DefinitionRepositoryクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setDefRepository() throws NamingException
	{
		defRepository = (DefinitionRepository)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/DefinitionRepositoryBean/jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository");
	}
	
	/**
	 * DefinitionRepositoryクラスのインスタンスを返す。
	 * @return DefinitionRepositoryクラスのインスタンス
	 */
	public DefinitionRepository getDefRepository()
	{
		return defRepository; 
	}
	
	/**
	 * RepositoryLoaderクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setRepLoader() throws NamingException
	{
		repLoader = (RepositoryLoader)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/RepositoryLoaderBean/jp.co.argo21.nautica.workflow.engine.RepositoryLoader");
	}
	
	/**
	 * RepositoryLoaderクラスのインスタンスを返す。
	 * @return RepositoryLoaderクラスのインスタンス
	 */
	public RepositoryLoader getRepLoader()
	{
		return repLoader;
	}
	
	/**
	 * WorkflowEngineHandlerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setWfEngine() throws NamingException
	{
		wfEngine = (WorkflowEngineHandler)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/WorkflowEngineHandlerBean/jp.co.argo21.nautica.workflow.wfmc.WorkflowEngineHandler");
	}
	
	/**
	 * WorkflowEngineHandlerクラスのインスタンスを返す。
	 * @return WorkflowEngineHandlerクラスのインスタンス
	 */
	public WorkflowEngineHandler getWfEngine()
	{
		return wfEngine;
	}
	
	/**
	 * WorkflowAdminHandlerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setWfAdmin() throws NamingException
	{
		wfAdmin = (WorkflowAdminHandler)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/WorkflowAdminHandlerBean/jp.co.argo21.nautica.workflow.wfmc.WorkflowAdminHandler");
	}
	
	/**
	 * WorkflowAdminHandlerクラスのインスタンスを返す。
	 * @return WorkflowAdminHandlerクラスのインスタンス
	 */
	public WorkflowAdminHandler getWfAdmin()
	{
		return wfAdmin;
	}
	
	/**
	 * WorkItemHandlerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setWfItem() throws NamingException
	{
		wfItem = (WorkItemHandler)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/WorkItemHandlerBean/jp.co.argo21.nautica.workflow.wfmc.WorkItemHandler");
	}
	
	/**
	 * WorkItemHandlerクラスのインスタンスを返す。
	 * @return WorkItemHandlerクラスのインスタンス
	 */
	public WorkItemHandler getWfItem()
	{
		return wfItem;
	}
	
	/**
	 * UserManagerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setUsrManager() throws NamingException
	{
		usrManager = (UserManager)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/UserManagerBean/jp.co.argo21.nautica.workflow.security.UserManager");
	}
	
	/**
	 * UserManagerクラスのインスタンスを返す。
	 * @return UserManagerクラスのインスタンス
	 */
	public UserManager getUsrManager()
	{
		return usrManager;
	}
	
	/**
	 * RoleManagerクラスのインスタンスをセットする。
	 * @throws NamingException
	 */
	private void setRoleManager() throws NamingException
	{
		roleManager = (RoleManager)GeronimoUtils.getEJB(
				NAUTICA_EJB_PATH,
				"nautica-workflow/RoleManagerBean/jp.co.argo21.nautica.workflow.security.RoleManager");
	}
	
	/**
	 * RoleManagerクラスのインスタンスを返す。
	 * @return
	 */
	public RoleManager getRoleManager()
	{
		return roleManager;
	}
}
