/* $Id: SimulationListener.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.util.List;

import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;

/**
 * シミュレーションの状態を返すためのリスナー。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public interface SimulationListener
{
	/**
	 * シミュレーションが開始されたことを通知する。
	 * 
	 * @param act	対象のアクティビティラッパー
	 */
	public void simulationStarted(SimulatableActivityWrapper act);

	/**
	 * シミュレーションが進展したことを通知する。
	 * 
	 * @param act	対象のアクティビティラッパー
	 * @param trs	結果となる遷移情報
	 */
	public void simulationProgressed(SimulatableActivityWrapper act, List<TransitionElement> trs);

	/**
	 * シミュレーションが完了したことを通知する。 
	 * 
	 * @param act	対象のアクティビティラッパー
	 */
	public void simulationFinished(SimulatableActivityWrapper act);

	/**
	 * シミュレーションが中断したことを通知する。
	 * 
	 * @param act	対象のアクティビティラッパー
	 */
	public void simulationTerminated(SimulatableActivityWrapper act);
}
