/* $Id: NoInspectableInspector.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;

import javax.swing.JLabel;
import javax.swing.JPanel;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * 非選択時のダミーインスペクタ
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class NoInspectableInspector extends JPanel implements Inspector
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** 自動コミット用のフラグ */
	private boolean isAutoCommit;
	
	/** メッセージ用フォント */
	private static final Font FONT = new Font("SansSerif", Font.PLAIN, 24);

	/**
	 * ダミーインスペクタを生成する。
	 */
	public NoInspectableInspector()
	{
		isAutoCommit = true;
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JLabel label = new JLabel(rm.getResource("NoInspectableInspector.label"));
		label.setFont(NoInspectableInspector.FONT);
		label.setHorizontalAlignment(JLabel.CENTER);
		label.setForeground(Color.gray);

		LayoutManager layout = new BorderLayout();
		setLayout(layout);

		add(label, BorderLayout.CENTER);	
	}

	/**
	 * インスペクト対象を返す。
	 * 
	 * @return	インスペクト対象
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#getInspectable()
	 */	
	public final Element getInspectable()
	{
		return null;
	}

	/**
	 * インスペクト対象を設定する。
	 * 
	 * @param r	対象要素
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */	
	public final void setInspectable(Element r)
	{
		//何もしない
	}

	/**
	 * インスペクタが自動コミットするかどうかを返す。
	 * 
	 * @return	自動コミットの場合にはtrue
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#isAutoCommit()
	 */	
	public boolean isAutoCommit()
	{
		return this.isAutoCommit;
	}

	/**
	 * 設定値をチェックする。
	 * 
	 * @return	チェック結果
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#check()
	 */	
	public boolean check()
	{
		return true;
	}

	/**
	 * 設定値をコミットする。
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */	
	public void commit()
	{
		//NOP
	}

	/**
	 * インスペクタを初期化する。
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		//NOP
	}

	/**
	 * インスペクタのアンロードを行う。
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#unload()
	 */
	public void unload()
	{
		//NOP
	}
}
