/* $Id: Inspector.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * インスペクタ用の基本インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Inspector
{
	/**
	 * インスペクト対象を返す。
	 * 
	 * @return	インスペクト対象
	 */
	public Element getInspectable();

	/**
	 * インスペクト対象を設定する。
	 * 
	 * @param elem	対象要素
	 */	
	public void setInspectable(Element elem);

	/**
	 * インスペクタを初期化する。
	 */	
	public void init();

	/**
	 * 設定値をチェックする。
	 * 
	 * @return	チェック結果
	 */
	public boolean check();

	/**
	 * 設定値をコミットする。
	 */	
	public void commit();

	/**
	 * インスペクタが自動コミットするかどうかを返す。
	 * 
	 * @return	自動コミットの場合にはtrue
	 */	
	public boolean isAutoCommit();

	/**
	 * インスペクタのアンロードを行う。
	 */	
	public void unload();
}
