/* $Id: ConditionalVariable.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.expression;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

/**
 * 条件評価に利用される変数の格納用。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ConditionalVariable
{
	/** STRING */
	public static final int STRING  = VariableElement.STRING;
	/** INTEGER */
	public static final int INTEGER = VariableElement.INTEGER;
	/** BOOLEAN */
	public static final int BOOLEAN = VariableElement.BOOLEAN;

	/** 変数 */
	private VariableElement var;
	/** 値 */
	private String value;

	/**
	 * 条件評価に利用される変数の格納用一時変数を生成する。
	 * 
	 * @param var	元となる変数
	 */
	public ConditionalVariable(VariableElement var)
	{
		this.var = var;
		this.value = var.getInitialValue();
	}

	/**
	 * 条件評価に利用される変数の格納用一時変数を生成する。
	 * 
	 * @param var	元となる変数
	 * @param value	初期値
	 */
	public ConditionalVariable(VariableElement var, String value)
	{
		this.var = var;
		this.value = value;
	}

	/**
	 * IDを返す。
	 * 
	 * @return ID
	 */
	public String getID()
	{
		return var.getID();
	}

	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 */
	public String getName()
	{
		return var.getName();
	}

	/**
	 * 型を返す。
	 * 
	 * @return	型
	 */
	public int getType()
	{
		return var.getType();
	}

	/**
	 * ツールチップを返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	ツールチップ
	 */
	public String getTooltipText(ResourceManager rm)
	{
		return var.getTooltipText(rm);
	}

	/**
	 * 値を返す。
	 * 
	 * @return 値
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * 値を設定する。
	 * 
	 * @return 値
	 */
	public void setValue(String v)
	{
		value = v;
	}
}

