/* $Id: VariableElementImpl.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;

import jp.co.argo21.nautica.commons.util.IDGenerator;
import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

/**
 * プロセス変数
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class VariableElementImpl implements VariableElement
{
	/** ID */
	private String id;
	/** 名称 */
	private String name;
	/** 備考 */
	private String description;
	/** 型 */
	private int type;
	/** 初期値 */
	private String initialValue;
	/** 初期化済みフラグ */
	private boolean isInitialized;

	/**
	 * プロセス変数を生成する。
	 * 
	 * @param n	名称
	 */
	public VariableElementImpl(String n)
	{
		setID(IDGenerator.generate(ID_PREFIX));
		setName(n);
		setDescription("");
		setType(STRING);
		setInitialValue("");
		isInitialized = false;
	}

	/**
	 * プロセス変数を生成する。
	 * 
	 * @param df	XmlObject
	 */
	public VariableElementImpl(DataFieldDocument.DataField df)
	{
		String id = df.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(df.getName());
		setDescription(df.getDescription());
		setInitialValue(df.getInitialValue());
		
		DataTypeDocument.DataType t = df.getDataType();
		if (t != null && t.isSetBasicType()) {
			BasicTypeDocument.BasicType bt = t.getBasicType();
			BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
			setType(type.intValue());
			isInitialized = true;
		} else {
			setType(STRING);
			isInitialized = false;
		}
	}

	/**
	 * IDを設定する。
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	/**
	 * 初期化済みかどうかを返す。
	 * 
	 * @return	初期化済みならtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.VariableElement#isInitialized()
	 */
	public boolean isInitialized()
	{
		return isInitialized;
	}

	/**
	 * 説明を返す。
	 * 
	 * @return 説明
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDを返す。
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * 説明を設定する。
	 * 
	 * @param desc 説明
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * 名称を設定する。
	 * 
	 * @param name 名称
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setName(java.lang.String)
	 */
	public void setName(String name)
	{
		this.name = name;
	}
	/**
	 * 初期値を返す。
	 * 
	 * @return	初期値
	 * @see jp.co.argo21.nautica.tool.wfd.element.VariableElement#getInitialValue()
	 */
	public String getInitialValue()
	{
		return initialValue;
	}

	/**
	 * 型を返す。
	 * 
	 * @return	型
	 * @see jp.co.argo21.nautica.tool.wfd.element.VariableElement#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * 初期値を設定する。
	 * 
	 * @param v	初期値
	 * @see jp.co.argo21.nautica.tool.wfd.element.VariableElement#setInitialValue(java.lang.String)
	 */
	public void setInitialValue(String v)
	{
		initialValue = v;
	}

	/**
	 * 型を設定する。
	 * 
	 * @param i	型
	 * @see jp.co.argo21.nautica.tool.wfd.element.VariableElement#setType(int)
	 */
	public void setType(int i)
	{
		type = i;
		isInitialized = true;
	}

	/**
	 * ツールボックス文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getTooltipText(jp.co.argo21.nautica.commons.util.ResourceManager)
	 */
	public String getTooltipText(ResourceManager rm)
	{
		StringBuffer s = new StringBuffer();
		s = s.append("<html>");
		s = s.append("<b>").append(getName()).append("</b>");
		s = s.append("<table border>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("VariableElement.label.0"))
			.append("</td><td width=150>")
			.append(getID())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("VariableElement.label.7"))
			.append("</td><td width=150>");
		int t = getType();
		if (t == VariableElement.STRING) {
			s = s.append(rm.getResource("VariableElement.label.3"));
		} else if (t == VariableElement.INTEGER) {
			s = s.append(rm.getResource("VariableElement.label.4"));
		} else if (t == VariableElement.BOOLEAN) {
			s = s.append(rm.getResource("VariableElement.label.5"));
		} else {
			s = s.append(rm.getResource("VariableElement.label.3"));
		}
		s = s.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("VariableElement.label.6"))
			.append("</td><td width=150>")
			.append(getInitialValue())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("VariableElement.label.2"))
			.append("</td><td width=150>")
			.append(getDescription())
			.append("</td></tr>");
		s = s.append("</table>");
		s = s.append("</html>");
		return s.toString();
	}

	/**
	 * 印刷用文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getPrintText(jp.co.argo21.nautica.commons.util.ResourceManager)
	 */
	public String getPrintText(ResourceManager rm)
	{	
		StringBuffer s = new StringBuffer();
		return s.toString();
	}

	/**
	 * 指定された要素を使用中かどうかを返す。
	 *
	 * @param elem 要素
	 * @return 使用中ならtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#isUsed(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public boolean isUsed(Element elem)
	{
		return false;
	}
}
