/* $Id: ParameterElementImpl.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.DataTypeDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;

import jp.co.argo21.nautica.commons.util.IDGenerator;
import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;

/**
 * パラメータ
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ParameterElementImpl implements ParameterElement
{
	/** ID */
	private String id;
	/** 名称 */
	@SuppressWarnings("unused")
	private String name;
	/** 備考 */
	private String description;
	/** パラメータ型 */
	private int type;
	/** 入出力モード */
	private int mode;
	
	/**
	 * パラメータを生成する。
	 * 
	 * @param n	名称
	 */
	public ParameterElementImpl(String n)
	{
		setID(IDGenerator.generate(ID_PREFIX));
		setName(n);
		setDescription("");
		setType(STRING);
		setMode(INOUT);
	}
	
	/**
	 * パラメータを生成する。
	 * 
	 * @param pm	XmlObject
	 */
	public ParameterElementImpl(FormalParameterDocument.FormalParameter pm)
	{
		String id = pm.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}

		setDescription(pm.getDescription());

		if (pm.isSetMode()) {
			setMode(pm.getMode().intValue());
		}
		
		DataTypeDocument.DataType t = pm.getDataType();
		if (t.isSetBasicType()) {
			BasicTypeDocument.BasicType bt = t.getBasicType();
			BasicTypeDocument.BasicType.Type.Enum type = bt.getType();
			setType(type.intValue());
		}
	}

	/**
	 * IDを設定する。
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * 説明を返す。
	 * 
	 * @return 説明
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDを返す。
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getName()
	 */
	public String getName()
	{
		return getID();
	}

	/**
	 * 説明を設定する。
	 * 
	 * @param desc 説明
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * 名称を設定する。ただし、このメソッドは何もしない。
	 * 
	 * @param name 名称
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setName(java.lang.String)
	 */
	public void setName(String name)
	{
		//NOP
	}
	/**
	 * 入出力モードを返す。
	 * 
	 * @return	入出力モード
	 * @see jp.co.argo21.nautica.tool.wfd.element.ParameterElement#getMode()
	 */
	public int getMode()
	{
		return mode;
	}

	/**
	 * パラメータ型を返す。
	 * 
	 * @return	パラメータ型
	 * @see jp.co.argo21.nautica.tool.wfd.element.ParameterElement#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * 入出力モードを設定する。
	 * 
	 * @param i	入出力モード
	 * @see jp.co.argo21.nautica.tool.wfd.element.ParameterElement#setMode(int)
	 */
	public void setMode(int i)
	{
		mode = i;
	}

	/**
	 * パラメータ型を設定する。
	 * 
	 * @param i	パラメータ型
	 * @see jp.co.argo21.nautica.tool.wfd.element.ParameterElement#setType(int)
	 */
	public void setType(int i)
	{
		type = i;
	}

	/**
	 * ツールボックス文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getTooltipText(jp.co.argo21.nautica.commons.util.ResourceManager)
	 */
	public String getTooltipText(ResourceManager rm)
	{
		StringBuffer s = new StringBuffer();
		s = s.append("<html>");
		s = s.append("<b>").append(getName()).append("</b>");
		s = s.append("<table border>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ParameterElement.label.0"))
			.append("</td><td width=150>")
			.append(getID())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ParameterElement.label.2"))
			.append("</td><td width=150>");
		int t = getType();
		if (t == ParameterElement.STRING) {
			s = s.append(rm.getResource("ParameterElement.type.0"));
		} else if (t == ParameterElement.INTEGER) {
			s = s.append(rm.getResource("ParameterElement.type.1"));
		} else if (t == ParameterElement.BOOLEAN) {
			s = s.append(rm.getResource("ParameterElement.type.2"));
		} else {
			s = s.append(rm.getResource("ParameterElement.type.0"));
		}
		s = s.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ParameterElement.label.3"))
			.append("</td><td width=150>");
		int m = getMode();
		if (m == ParameterElement.IN) {
			s = s.append(rm.getResource("ParameterElement.mode.0"));
		} else if (m == ParameterElement.OUT) {
			s = s.append(rm.getResource("ParameterElement.mode.1"));
		} else if (m == ParameterElement.INOUT) {
			s = s.append(rm.getResource("ParameterElement.mode.2"));
		} else {
			s = s.append(rm.getResource("ParameterElement.mode.2"));
		}
		s = s.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ParameterElement.label.4"))
			.append("</td><td width=150>")
			.append(getDescription())
			.append("</td></tr>");
		s = s.append("</table>");
		s = s.append("</html>");
		return s.toString();
	}

	/**
	 * 印刷用文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getPrintText(jp.co.argo21.nautica.commons.util.ResourceManager)
	 */
	public String getPrintText(ResourceManager rm)
	{	
		StringBuffer s = new StringBuffer();
		return s.toString();
	}

	/**
	 * 指定された要素を使用中かどうかを返す。
	 *
	 * @param elem 要素
	 * @return 使用中ならtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#isUsed(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public boolean isUsed(Element elem)
	{
		return false;
	}
}
