/* $Id: EndActivityState.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;

/**
 * 終了アクティビティ状態
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class EndActivityState extends AbstractActivityState
{
	/** アイコン名 */
	private static final String ICON_NAME = "end";

	/**
	 * 終了アクティビティ状態を生成する。
	 */
	public EndActivityState()
	{
	}

	/**
	 * アクティビティ型を返す。
	 * 
	 * @return アクティビティ型
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityState#getType()
	 */
	public String getType()
	{
		return ActivityElement.END;
	}
	
	/**
	 * 表示アイコン名を返す。
	 * 
	 * @return アイコン名
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityState#getIconName()
	 */
	public String getIconName()
	{
		return ICON_NAME;
	}
}
