/* $Id: ApplicationElementImpl.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.ArrayList;
import java.util.List;

import org.wfmc.x2002.xpdl10.ApplicationDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;
import org.wfmc.x2002.xpdl10.FormalParametersDocument;

import jp.co.argo21.nautica.commons.util.IDGenerator;
import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;

/**
 * アプリケーション要素
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class ApplicationElementImpl implements ApplicationElement
{
	/** ID */
	private String id;
	/** 名称 */
	private String name;
	/** 備考 */
	private String description;
	/** パラメータ一覧 */
	private List<ParameterElement> parameters = new ArrayList<ParameterElement>();

	/**
	 * アプリケーション要素を生成する。
	 * 
	 * @param n	名称
	 */
	public ApplicationElementImpl(String n)
	{
		setID(IDGenerator.generate(ID_PREFIX));
		setName(n);
		setDescription("");
	}

	/**
	 * アプリケーション要素を生成する。
	 * 
	 * @param app	XmlObject
	 */
	public ApplicationElementImpl(ApplicationDocument.Application app)
	{
		String id = app.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(app.getName());
		setDescription(app.getDescription());
		
		if (app.isSetFormalParameters()) {
			FormalParametersDocument.FormalParameters pms = app.getFormalParameters();
			int count = pms.sizeOfFormalParameterArray();
			for (int i = 0; i < count; i++) {
				FormalParameterDocument.FormalParameter pm = pms.getFormalParameterArray(i);
				ParameterElement e = new ParameterElementImpl(pm);
				addParameter(e);
			}
		}
	}

	/**
	 * IDを設定する。
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * パラメータを追加する。
	 * 
	 * @param param	パラメータ
	 * @see jp.co.argo21.nautica.tool.wfd.element.ApplicationElement#addParameter(jp.co.argo21.nautica.tool.wfd.element.ParameterElement)
	 */
	public void addParameter(ParameterElement param)
	{
		this.parameters.add(param);
	}

	/**
	 * パラメータ一覧を返す。
	 * 
	 * @return	パラメータ一覧
	 * @see jp.co.argo21.nautica.tool.wfd.element.ApplicationElement#getParameters()
	 */
	public List<ParameterElement> getParameters()
	{
		return parameters;
	}

	/**
	 * パラメータを削除する。
	 * 
	 * @param param
	 * @see jp.co.argo21.nautica.tool.wfd.element.ApplicationElement#removeParameter(jp.co.argo21.nautica.tool.wfd.element.ParameterElement)
	 */
	public void removeParameter(ParameterElement param)
	{
		this.parameters.remove(param);
	}

	/**
	 * 説明を返す。
	 * 
	 * @return 説明
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDを返す。
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * 説明を設定する。
	 * 
	 * @param desc 説明
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * 名称を設定する。
	 * 
	 * @param name 名称
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setName(java.lang.String)
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * ツールボックス文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getTooltipText(jp.co.argo21.nautica.commons.util.ResourceManager)
	 */
	public String getTooltipText(ResourceManager rm)
	{
		StringBuffer s = new StringBuffer();
		s = s.append("<html>");
		s = s.append("<b>").append(getName()).append("</b>");
		s = s.append("<table border>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ApplicationElement.label.0"))
			.append("</td><td width=150>")
			.append(getID())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ApplicationElement.label.2"))
			.append("</td><td width=150>")
			.append(getDescription())
			.append("</td></tr>");
		s = s.append("</table>");
		s = s.append("</html>");
		return s.toString();
	}

	/**
	 * 印刷用文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getPrintText(jp.co.argo21.nautica.commons.util.ResourceManager)
	 */
	public String getPrintText(ResourceManager rm)
	{	
		StringBuffer s = new StringBuffer();
		return s.toString();
	}

	/**
	 * 指定された要素を使用中かどうかを返す。
	 *
	 * @param elem 要素
	 * @return 使用中ならtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#isUsed(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public boolean isUsed(Element elem)
	{
		return false;
	}
}
