/* $Id: VariableElement.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;

/**
 * プロセス変数定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface VariableElement extends Element
{
	/** プロセス変数ID接頭辞 */
	public static final String ID_PREFIX  = "VR";

	/** 文字列 */
	public static final int STRING    = BasicTypeDocument.BasicType.Type.INT_STRING;
	/** 実数 */
	public static final int FLOAT     = BasicTypeDocument.BasicType.Type.INT_FLOAT;
	/** 整数 */
	public static final int INTEGER   = BasicTypeDocument.BasicType.Type.INT_INTEGER;
	/** 日時 */
	public static final int DATETIME  = BasicTypeDocument.BasicType.Type.INT_DATETIME;
	/** 真理値 */
	public static final int BOOLEAN   = BasicTypeDocument.BasicType.Type.INT_BOOLEAN;

	/**
	 * 初期化済みかどうかを返す。
	 * 
	 * @return	初期化済みならtrue
	 */
	public boolean isInitialized();

	/**
	 * 変数型を返す。
	 * 
	 * @return	変数型
	 */
	public int getType();

	/**
	 * 初期値を返す。
	 * 
	 * @return	初期値
	 */
	public String getInitialValue();

	/**
	 * 型を設定する。
	 * 
	 * @param type	型
	 */	
	public void setType(int type);

	/**
	 * 初期値を設定する。
	 * 
	 * @param value	初期値
	 */
	public void setInitialValue(String value);
}
