/* $Id: ProcessElement.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import java.util.List;

import org.wfmc.x2002.xpdl10.ProcessHeaderDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;

/**
 * プロセス定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface ProcessElement extends Element
{
	/** プロセスID接頭辞 */
	public static final String ID_PREFIX  = "PS";

	/** 論理座標幅取得キー */
	public static final String LOGICAL_WIDTH  = "LOGICAL_WIDTH";
	/** 論理座標高さ取得キー */
	public static final String LOGICAL_HEIGHT = "LOGICAL_HEIGHT";

	/** ルートプロセス */
	public static final int PUBLIC  = WorkflowProcessDocument.WorkflowProcess.AccessLevel.INT_PUBLIC;
	/** サブプロセス */
	public static final int PRIVATE = WorkflowProcessDocument.WorkflowProcess.AccessLevel.INT_PRIVATE;

	/** 年 */
	public static final int YEAR   = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_Y;
	/** 月 */
	public static final int MONTH  = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_M;
	/** 日 */
	public static final int DAY    = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_D;
	/** 時間 */
	public static final int HOUR   = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_H;
	/** 分 */
	public static final int MINUTE = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_M_2;
	/** 秒 */
	public static final int SECOND = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_S;

	/**
	 * 期間単位を返す。
	 * 
	 * @return	期間単位
	 */
	public int getDurationUnit();

	/**
	 * 実行期限を返す。
	 * 
	 * @return	実行期限
	 */
	public int getLimit();

	/**
	 * アクセスレベルを返す。
	 * 
	 * @return	アクセスレベル
	 */
	public int getAccessLevel();

	/**
	 * 論理座標幅を返す。
	 * 
	 * @return	論理座標幅
	 */
	public int getLogicalWidth();

	/**
	 * 論理座標高さを返す。
	 * 
	 * @return	論理座標高さ
	 */
	public int getLogicalHeight();

	/**
	 * 通知者一覧を返す。
	 * 
	 * @return	通知者一覧
	 */
	public List<String> getResponsibles();

	/**
	 * パラメータ一覧を返す。
	 * 
	 * @return	パラメータ一覧
	 */
	public List<ParameterElement> getParameters();

	/**
	 * アクティビティ一覧を返す。
	 * 
	 * @return	アクティビティ一覧
	 */
	public List<ActivityElement> getActivities();

	/**
	 * 遷移一覧を返す。
	 * 
	 * @return	遷移一覧
	 */
	public List<TransitionElement> getTransitions();

	/**
	 * 期間単位を設定する。
	 * 
	 * @param unit	期間単位
	 */
	public void setDurationUnit(int unit);
	
	/**
	 * 実行期限を設定する。
	 * 
	 * @param limit	実行期限
	 */
	public void setLimit(int limit);
	
	/**
	 * 論理座標幅を設定する。
	 * 
	 * @param w	論理座標幅
	 */
	public void setLogicalWidth(int w);
	
	/**
	 * 論理座標高さを設定する。
	 * 
	 * @param h	論理座標高さ
	 */
	public void setLogicalHeight(int h);

	/**
	 * 通知者を追加する。
	 * 
	 * @param r	通知者
	 */
	public void addResponsible(String r);
	
	/**
	 * パラメータを追加する。
	 * 
	 * @param param	パラメータ
	 */
	public void addParameter(ParameterElement param);
	
	/**
	 * アクティビティを追加する。
	 * 
	 * @param act	アクティビティ
	 */
	public void addActivity(ActivityElement act);
	
	/**
	 * 遷移を追加する。
	 * 
	 * @param tr	遷移
	 */
	public void addTransition(TransitionElement tr);

	/**
	 * 通知者を削除する。
	 * 
	 * @param r	通知者
	 */
	public void removeResponsible(String r);
	
	/**
	 * パラメータを削除する。
	 * 
	 * @param param	パラメータ
	 */
	public void removeParameter(ParameterElement param);
	
	/**
	 * アクティビティを削除する。
	 * 
	 * @param act	アクティビティ
	 */
	public void removeActivity(ActivityElement act);
	
	/**
	 * 遷移を削除する。
	 * 
	 * @param tr	遷移
	 */
	public void removeTransition(TransitionElement tr);
}
