/* $Id: ParticipantElement.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import org.wfmc.x2002.xpdl10.ParticipantTypeDocument;

/**
 * ワークフロー参加者定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface ParticipantElement extends Element
{
	/** ワークフロー参加者ID接頭辞 */
	public static final String ID_PREFIX  = "PP";

	/** リソースセット */
	public static final int RESOURCE_SET        = ParticipantTypeDocument.ParticipantType.Type.INT_RESOURCE_SET;
	/** リソース */
	public static final int RESOURCE            = ParticipantTypeDocument.ParticipantType.Type.INT_RESOURCE;
	/** ロール */
	public static final int ROLE                = ParticipantTypeDocument.ParticipantType.Type.INT_ROLE;
	/** 組織単位 */
	public static final int ORGANIZATIONAL_UNIT = ParticipantTypeDocument.ParticipantType.Type.INT_ORGANIZATIONAL_UNIT;
	/** 人 */
	public static final int HUMAN               = ParticipantTypeDocument.ParticipantType.Type.INT_HUMAN;
	/** システム */
	public static final int SYSTEM              = ParticipantTypeDocument.ParticipantType.Type.INT_SYSTEM;

	/**
	 * 参加者型を返す。
	 * 
	 * @return	参加者型
	 */
	public int getType();

	/**
	 * 参加者型を設定する。
	 * 
	 * @param type	参加者型
	 */	
	public void setType(int type);
}
