/* $Id: PackageElement.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import java.util.List;

/**
 * パッケージ定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface PackageElement extends Element
{
	/** パッケージID接頭辞 */
	public static final String ID_PREFIX  = "PK";

	/**
	 * 作成日を返す。
	 * 
	 * @return	作成日
	 */
	public String getCreatedDate();
	
	/**
	 * 定義者を返す。
	 * 
	 * @return	定義者
	 */
	public String getAuthor();
	
	/**
	 * バージョンを返す。
	 * 
	 * @return	バージョン
	 */
	public String getVersion();
	
	/**
	 * ワークフロー参加者一覧を返す。
	 * 
	 * @return	ワークフロー参加者一覧
	 */
	public List<ParticipantElement> getParticipants();
	
	/**
	 * アプリケーション一覧を返す。
	 * 
	 * @return	アプリケーション一覧
	 */
	public List<ApplicationElement> getApplications();
	
	/**
	 * プロセス変数一覧を返す。
	 * 
	 * @return	プロセス変数一覧
	 */
	public List<VariableElement> getVariables();
	
	/**
	 * プロセス一覧を返す。
	 * 
	 * @return	プロセス一覧
	 */
	public List<ProcessElement> getProcesses();

	/**
	 * 作成日を設定する。
	 * 
	 * @param s	作成日
	 */
	public void setCreatedDate(String s);	

	/**
	 * 定義者を設定する。
	 * 
	 * @param s	定義者
	 */
	public void setAuthor(String s);

	/**
	 * バージョンを設定する。
	 * 
	 * @param s	バージョン
	 */
	public void setVersion(String s);

	/**
	 * ワークフロー参加者を追加する。
	 * 
	 * @param part	ワークフロー参加者
	 */
	public void addParticipant(ParticipantElement part);
	
	/**
	 * アプリケーションを追加する。
	 * 
	 * @param app	アプリケーション
	 */
	public void addApplication(ApplicationElement app);
	
	/**
	 * プロセス変数を追加する。
	 * 
	 * @param var	プロセス変数
	 */
	public void addVariable(VariableElement var);
	
	/**
	 * プロセスを追加する。
	 * 
	 * @param proc	プロセス
	 */
	public void addProcess(ProcessElement proc);

	/**
	 * ワークフロー参加者を削除する。
	 * 
	 * @param part	ワークフロー参加者
	 */
	public void removeParticipant(ParticipantElement part);
	
	/**
	 * アプリケーションを削除する。
	 * 
	 * @param app	アプリケーション
	 */
	public void removeApplication(ApplicationElement app);
	
	/**
	 * プロセス変数を削除する。
	 * 
	 * @param var	プロセス変数
	 */
	public void removeVariable(VariableElement var);
	
	/**
	 * プロセスを削除する。
	 * 
	 * @param proc	プロセス
	 */
	public void removeProcess(ProcessElement proc);
}
