/* $Id: ElementContext.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * 要素のドラッグ＆ドロップ用コンテキスト
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ElementContext implements Transferable
{
	/** MIMEタイプ */
	public static final String MIME_TYPE
		= WorkflowDesignerConstants.PTYPE
		+ "/"
		+ WorkflowDesignerConstants.STYPE_ELEMENT;

	/** データフレーバー */
	private DataFlavor[] flavors;
	/** 要素 */
	private Element element;

	/**
	 * コンテキストを生成する。
	 * 
	 * @param elem	要素
	 * @param type	型
	 */		
	public ElementContext(Element elem, String type)
	{
		DataFlavor flavor
			= new DataFlavor(MIME_TYPE, "");
		flavors = new DataFlavor[1];
		flavor.setHumanPresentableName(type);
		flavors[0] = flavor;
		element = elem;
	}
	
	/**
	 * 転送データである要素を返す。
	 * 
	 * @param flavor	データフレーバー
	 * @return	転送データ
	 * @see java.awt.datatransfer.Transferable#getTransferData(java.awt.datatransfer.DataFlavor)
	 */	
	public Object getTransferData(DataFlavor flavor)
	{
		if (isDataFlavorSupported(flavor)) {
			return element;
		} else {
			return null;
		}
	}

	/**
	 * データフレーバーを返す。
	 * 
	 * @return	データフレーバー
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 */
	public DataFlavor[] getTransferDataFlavors()
	{
		return flavors;
	}

	/**
	 * 指定されたデータフレーバーをサポートするかどうかを返す。
	 * 
	 * @param flavor	データフレーバー。
	 * @return	サポートの是非
	 * @see java.awt.datatransfer.Transferable#isDataFlavorSupported(java.awt.datatransfer.DataFlavor)
	 */
	public boolean isDataFlavorSupported(DataFlavor flavor)
	{
		if (flavor.getSubType().equals(WorkflowDesignerConstants.STYPE_ELEMENT)) {
			return true;
		} else {
			return false;
		}
	}
}
