/* $Id: ActivityItemContext.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;

/**
 * アクティビティ項目のドラッグ＆ドロップ用コンテキスト。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ActivityItemContext implements Transferable
{
	/** MIMEタイプ */
	public static final String MIME_TYPE
		= WorkflowDesignerConstants.PTYPE
		+ "/"
		+ WorkflowDesignerConstants.STYPE_ACTIVITY_ITEM;

	/** データフレーバー */
	private DataFlavor[] flavors;
		
	/**
	 * アクティビティ項目のドラッグ＆ドロップ用コンテキストを生成する。
	 * 
	 * @param n アクティビティ項目名
	 */
	public ActivityItemContext(String n)
	{
		DataFlavor flavor = new DataFlavor(MIME_TYPE, n);
		flavors = new DataFlavor[1];
		flavors[0] = flavor;
	}
		
	/**
	 * フレーバーに対応する転送オブジェクトを返す。
	 * 
	 * @param flavor フレーバー
	 * @return フローアイテム名
	 * @see java.awt.datatransfer.Transferable#getTransferData(java.awt.datatransfer.DataFlavor)
	 */
	public Object getTransferData(DataFlavor flavor)
	{
		if (isDataFlavorSupported(flavor)) {
			return IconManager.getIcon(flavor.getHumanPresentableName());
		} else {
			return null;
		}
	}

	/**
	 * フレーバーを返す。
	 * 
	 * @return フレーバー
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 */
	public DataFlavor[] getTransferDataFlavors()
	{
		return flavors;
	}

	/**
	 * 指定されたフレーバーをサポートするかどうかを返す。
	 * 
	 * @param flavor フレーバー
	 * @return サポートする場合はtrue。
	 * @see java.awt.datatransfer.Transferable#isDataFlavorSupported(java.awt.datatransfer.DataFlavor)
	 */
	public boolean isDataFlavorSupported(DataFlavor flavor)
	{
		if (flavor.getSubType().equals(WorkflowDesignerConstants.STYPE_ACTIVITY_ITEM)) {
			return true;
		} else {
			return false;
		}
	}
}
