/* $Id: WorkflowDesignerConstants.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

/**
 * デザイナーで使われる共通定数
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface WorkflowDesignerConstants
{
	/** パッケージ */
	public static final String EL_PACKAGE     = "package";
	/** ワークフロー参加者 */
	public static final String EL_PARTICIPANT = "participant";
	/** アプリケーション */
	public static final String EL_APPLICATION = "application";
	/** プロセス変数 */
	public static final String EL_VARIABLE    = "variable";
	/** プロセス */
	public static final String EL_PROCESS     = "process";
	/** パラメータ */
	public static final String EL_PARAMETER   = "parameter";

	/** 対話型 */
	public static final String PAL_INTERACTIVE = "interactive";
	/** 自動実行 */
	public static final String PAL_AUTOMATIC   = "automatic";
	/** サブプロセス */
	public static final String PAL_SUBPROCESS  = "subprocess";
	/** 並列処理 */
	public static final String PAL_CONCURRENT  = "concurrent";
	/** 終了 */
	public static final String PAL_END         = "end";

	/** ドロップ可能アイテム一覧 */
	public static final String[] DROPPABLE_ITEMS = {
		PAL_INTERACTIVE,
		PAL_AUTOMATIC,
		PAL_SUBPROCESS,
		PAL_CONCURRENT,
		PAL_END
	};

	/** プライマリMIMEタイプ */
	public static final String PTYPE = "x-workflowdesigner";
	/** サブMIMEタイプ(アクティビティ項目) */
	public static final String STYPE_ACTIVITY_ITEM = "activity-item";
	/** サブMIMEタイプ(定義要素) */
	public static final String STYPE_ELEMENT = "element";
}