/* $Id: VersionWindow.java,v 1.2 2007/10/24 09:11:48 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;

/**
 * Nautica WorkflowDesignerのバージョン表示画面である。
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public final class VersionWindow extends JWindow
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** 製品ロゴイメージリソースパス名 */
	private static final String path
		= "/jp/co/argo21/nautica/tool/wfd/images/versionlogo.png";

	/** バージョン表示 */
	private static final String version = "Version 1.0";

	/** 著作権表示 */
	private static final String copyright
		= "Copyright \u00a92005 ARGO 21, Corp. all rights reserved.";

	/** 製品ロゴイメージ */
	private static Icon logo;

	/** 製品ロゴフォント */
	private static Font font = new Font("SansSerif", Font.BOLD, 12);

	/**
	 * ロゴの初期化
	 */
	static
	{
		logo = new ImageIcon(VersionWindow.class.getResource(path));
	}

	/**
	 * バージョン表示画面を生成する。
	 */
	public VersionWindow()
	{
		VersionPanel panel = new VersionPanel();
		setContentPane(panel);
		pack();

		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension size = getSize();
		setBounds(
			(screenSize.width - size.width) / 2,
			(screenSize.height - size.height) * 2 / 5,
			size.width,
			size.height
			);
	}
	
	/**
	 * バージョン表示画面を表示する。
	 * 
	 * @see java.awt.Component#show()
	 */
//	public void show()
//	{
//		//JWindowは後ろに回ると前に出ないので、いったん閉じて開きなおす。
//		this.setVisible(false);
//		this.setVisible(true);
//	}

	/**
	 * バージョン表示用パネルである。
	 *
	 */
	private final class VersionPanel extends JPanel
	{
		/** シリアルバージョンID */
		private static final long serialVersionUID = 1L;

		/**
		 * バージョン表示用エリアを生成する。
		 */
		private VersionPanel() {
			// 表示エリアをロードしたイメージのサイズにあわせる。
			Dimension size = new Dimension(logo.getIconWidth(), logo.getIconHeight());
			this.setPreferredSize(size);

			addMouseListener(
				new MouseAdapter() {
					public void mouseReleased(MouseEvent e) {
						VersionWindow.this.setVisible(false);
					}
				}
			);
		}

		/**
		 * バージョン表示を描画する。
		 *
		 * @param	g	描画対象グラフィックス
		 */
		public void paint(Graphics g)
		{
			logo.paintIcon(this, g, 0, 0);

			Dimension size = this.getSize();
			FontMetrics metrics = g.getFontMetrics(font);
			int height = metrics.getHeight();
			int descent = metrics.getDescent();

			g.setColor(Color.gray);
			g.setFont(font);

			int width = metrics.stringWidth(version);
			int dx = (size.width - width) / 2;
			int dy = size.height - (height + descent + 35);
			g.drawString(version, dx, dy);

			width = metrics.stringWidth(copyright);
			dx = (size.width - width) / 2;
			dy = size.height - (descent + 10);
			g.drawString(copyright, dx, dy);

			g.dispose();
		}
	}
}
