/* $Id: ValidationDialog.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.*;

import jp.co.argo21.nautica.commons.util.ResourceManager;

/**
 * 検証結果表示用のダイアログを提供する。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class ValidationDialog extends JDialog
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** 描画用フォント */
	private static final Font FONT = new Font("SansSerif", Font.PLAIN, 24);

	/** 結果ビュー */
	private static ValidationResultView resultView;
	/** エラーなしビュー */
	private static JLabel noResultView;

	/**
	 * ビューの初期化
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		resultView = new ValidationResultView();

		noResultView = new JLabel(rm.getResource("ValidationDialog.label.0"));
		noResultView.setPreferredSize(new Dimension(400, 200));
		noResultView.setFont(FONT);
		noResultView.setHorizontalAlignment(JLabel.CENTER);
		noResultView.setForeground(Color.gray);
	}

	/**
	 * 検証結果表示用のダイアログを表示する。
	 * 
	 * @param c	親コンポーネント
	 * @param results	結果内容
	 */
	public static void showDialog(Component c, List<ValidationResult> results)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		ValidationDialog dialog = new ValidationDialog(frame, results);
		dialog.setVisible(true);
		dialog.dispose();
	}

	/**
	 * 検証結果表示用のダイアログを生成する。
	 * 
	 * @param frame	親フレーム
	 * @param results	結果内容
	 */
	private ValidationDialog(Frame frame, List<ValidationResult> results)
	{
		super(frame, true);

		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		setTitle(rm.getResource("ValidationDialog.title"));
		
		JScrollPane scroll = new JScrollPane();
		if (results == null) {
			scroll.setViewportView(noResultView);
		} else {
			resultView.setResults(results);
			scroll.setViewportView(resultView);
		}

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
		closeButton.addActionListener(listener);
		getRootPane().setDefaultButton(closeButton);
		buttonPane.add(closeButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();

		setLocationRelativeTo(frame);
	}

	/**
	 * 閉じるボタン押下処理
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * ダイアログを閉じる。
		 * 
		 * @param e	イベント
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setVisible(false);
		}
	}
}
