/* $Id: TabbedToolBox.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.ArrayList;

import javax.swing.JTabbedPane;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;

/**
 * ツールボックス画面
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class TabbedToolBox extends JTabbedPane 
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** ツールバータブ */
	public static final int TAB_TOOLBAR = 0;
	/** ワークフロー参加者タブ */
	public static final int TAB_PARTICIPANT = 1;
	/** アプリケーションタブ */
	public static final int TAB_APPLICATION = 2;
	/** プロセス変数タブ */
	public static final int TAB_VARIABLE = 3;
	/** プロセスタブ */
	public static final int TAB_PROCESS = 4;

	/** ツールバー */
	private FlowDesignToolBar toolBar;
	/** ワークフロー参加者表示リスト */
	private ElementList participantList;
	/** アプリケーション表示リスト */
	private ElementList applicationList;
	/** プロセス変数表示リスト */
	private ElementList variableList;
	/** プロセス表示リスト */
	private ElementList processList;

	/**
	 * ツールボックスを生成する、
	 */
	public TabbedToolBox()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		toolBar = new FlowDesignToolBar();
		addTab(rm.getResource("TabbedToolBox.tab.0"), toolBar);
		participantList = new ElementList(new ArrayList<Element>(), WorkflowDesignerConstants.EL_PARTICIPANT);
		addTab(rm.getResource("TabbedToolBox.tab.1"), participantList);
		applicationList = new ElementList(new ArrayList<Element>(), WorkflowDesignerConstants.EL_APPLICATION);
		addTab(rm.getResource("TabbedToolBox.tab.2"), applicationList);
		variableList = new ElementList(new ArrayList<Element>(), WorkflowDesignerConstants.EL_VARIABLE);
		addTab(rm.getResource("TabbedToolBox.tab.3"), variableList);
		processList = new ElementList(new ArrayList<Element>(), WorkflowDesignerConstants.EL_PROCESS);
		addTab(rm.getResource("TabbedToolBox.tab.4"), processList);
	}
	
	/**
	 * ツールバーを返す。
	 * 
	 * @return	ツールバー
	 */
	public FlowDesignToolBar getToolBar()
	{
		return toolBar;
	}
	
	/**
	 * パッケージをロードする。
	 * 
	 * @param pkg	パッケージ
	 */
	public void loadElements(PackageElement pkg)
	{
		toolBar.init();
		participantList.setElements(pkg.getParticipants());
		applicationList.setElements(pkg.getApplications());
		variableList.setElements(pkg.getVariables());
		processList.setElements(pkg.getProcesses());
	}

}
