/* $Id: InspectorManager.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.Hashtable;
import java.util.Map;

import jp.co.argo21.nautica.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;
import jp.co.argo21.nautica.tool.wfd.inspector.NoInspectableInspector;

/**
 * インスペクタを管理するための基底クラス
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class InspectorManager
{
	/** デフォルトインスペクタ */
	public static final String DEFALT_INSPECTOR = "DEFAULT_INSPECTOR";

	/** インスペクタ一覧 */
	private Map<String, Inspector> inspectors = new Hashtable<String, Inspector>();

	/**
	 * インスペクタマネージャを生成する。
	 */
	public InspectorManager()
	{
		putInspectorForName(DEFALT_INSPECTOR, new NoInspectableInspector());
	}

	/**
	 * デフォルトインスペクタを返す。
	 * 
	 * @return	インスペクタ
	 */
	public Inspector getDefaultInspector()
	{
		return (Inspector)inspectors.get(DEFALT_INSPECTOR);
	}

	/**
	 * 指定された名前に対応したインスペクタを返す
	 * 
	 * @param name	インスペクタ名
	 * @return	インスペクタ
	 */
	public Inspector getInspectorForName(String name)
	{
		if (name == null) return getDefaultInspector();

		Inspector inspector = (Inspector)inspectors.get(name);
		if (inspector == null) return getDefaultInspector();

		return inspector;
	}

	/**
	 * 指定された名前でインスペクタを登録する。
	 * 
	 * @param name	インスペクタ名
	 * @param inspector	インスペクタ
	 */
	protected void putInspectorForName(String name, Inspector inspector)
	{
		if (StringUtils.checkNull(name)) return;
		if (inspector == null) return;
		
		inspectors.put(name, inspector);		
	}
}
