/* $Id: IconView.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

/**
 * アイコンビュー
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class IconView extends JComponent
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** サイズ */
	private static final Dimension VIEW_SIZE = new Dimension(60, 60);
	/** 枠線 */
	private static final Border border = BorderFactory.createEtchedBorder();

	/** アイコン名 */
	private String iconName;

	/**
	 * ビューを生成する。
	 */
	public IconView()
	{
		setSize(VIEW_SIZE);
		setPreferredSize(VIEW_SIZE);
		setMinimumSize(VIEW_SIZE);
	}

	/**
	 * 表示エリアを描画する。
	 *
	 * @param g 描画対象グラフィックス
	 */
	public void paintComponent(Graphics g)
	{
		Dimension size = this.getSize();

		//アイコンの描画
		if (iconName != null) {
			Icon icon = IconManager.getIcon(iconName);

			int iconX = (size.width - icon.getIconWidth()) / 2;
			int iconY = (size.height - icon.getIconHeight()) / 2;
			icon.paintIcon(this, g, iconX, iconY);
		}
		border.paintBorder(this, g, 0, 0, size.width, size.height);

		g.dispose();
	}

	/**
	 * アイコン名を返す。
	 * 
	 * @return	アイコン名
	 */
	public String getIconName()
	{
		return iconName;
	}

	/**
	 * アイコン名を設定する。
	 * 
	 * @param string	アイコン名
	 */
	public void setIconName(String string)
	{
		iconName = string;
	}
}

