/* $Id: IconManager.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * デザイナーで使用されるアイコンを一括管理する。
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class IconManager
{
	/** アイコン一覧 */
	private static Map<String, Icon> icons;
	
	/**
	 * 一覧生成
	 */
	static
	{
		icons = new HashMap<String, Icon>();
		Class<IconManager> c = IconManager.class;
		String path = "/jp/co/argo21/nautica/tool/wfd/images/";
		String ext = ".png";
		String[] names = {
			"application-cur",
			"application-s",
			"application",
			"async",
			"async-cur",
			"automatic",
			"automatic-cur",
			"concurrent-end",
			"concurrent-start",
			"concurrent",
			"concurrent-cur",
			"condition-s",
			"condition-cur",
			"condition",
			"connect-s",
			"connect",
			"end",
			"end-cur",
			"interactive",
			"interactive-cur",
			"package-cur",
			"package-s",
			"package",
			"parameter-cur",
			"participant-cur",
			"participant-s",
			"participant",
			"pointer-s",
			"pointer",
			"process-cur",
			"process-frameicon",
			"process-mini",
			"process-s",
			"process",
			"simulate-s",
			"simulate",
			"start",
			"start-cur",
			"subprocess",
			"subprocess-cur",
			"sync",
			"sync-cur",
			"validation-s",
			"validation",
			"variable-cur",
			"variable-s",
			"variable"
		};

		for (int i = 0; i < names.length; i++) {
			String n = names[i];
			Icon icon = new ImageIcon(c.getResource(path + n + ext));
			icons.put(n, icon);
		}
	}

	/**
	 * キーに対応するアイコンを返す。
	 * 
	 * @param key	キー
	 * @return	アイコン
	 */
	public static Icon getIcon(String key)
	{
		return (Icon)icons.get(key);
	}
}
