/* $Id: ElementFactory.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.impl.ApplicationElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ParameterElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ParticipantElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ProcessElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.VariableElementImpl;

/**
 * 要素生成用のファクトリ
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ElementFactory
{
	/** ファクトリ */
	static ElementFactory singleton = new ElementFactory();

	/**
	 * ファクトリのインスタンスを返す。
	 * 
	 * @return	ファクトリ
	 */
	public static ElementFactory getInstance()
	{
		return singleton;
	}
	
	/**
	 * ファクトリを生成する。
	 */
	private ElementFactory()
	{
	}

	/**
	 * 指定された要素を生成し返す。
	 * 
	 * @param elementKind	要素種別
	 * @return	要素
	 */
	public Element createElement(String elementKind)
	{
		if (elementKind == null) return null;

		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		String initialName = rm.getResource("Common.noname");

		if (elementKind.equals(WorkflowDesignerConstants.EL_VARIABLE)) {
			return new VariableElementImpl(initialName);
		} else if (elementKind.equals(WorkflowDesignerConstants.EL_PARTICIPANT)) {
			return new ParticipantElementImpl(initialName);
		} else if (elementKind.equals(WorkflowDesignerConstants.EL_APPLICATION)) {
			return new ApplicationElementImpl(initialName);
		} else if (elementKind.equals(WorkflowDesignerConstants.EL_PROCESS)) {
			return new ProcessElementImpl(initialName);
		} else if (elementKind.equals(WorkflowDesignerConstants.EL_PARAMETER)) {
			return new ParameterElementImpl(initialName);
		} else {
			return null;
		}
	}
}
