/* $Id: ActivityStateFactory.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.AutomaticActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.ConcurrentEndActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.ConcurrentStartActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.EndActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.InteractiveActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.StartActivityState;
import jp.co.argo21.nautica.tool.wfd.element.impl.SubprocessActivityState;

/**
 * アクティビティ生成用のファクトリ
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class ActivityStateFactory
{
	/** ファクトリ */
	static ActivityStateFactory singleton = new ActivityStateFactory();

	/**
	 * ファクトリのインスタンスを返す。
	 * 
	 * @return	ファクトリ
	 */
	public static ActivityStateFactory getInstance()
	{
		return singleton;
	}
	
	/**
	 * ファクトリを生成する。
	 */
	private ActivityStateFactory()
	{
	}
	
	/**
	 * 指定された種類のアクティビティを生成し、返す。
	 * 
	 * @param activityKind	アクティビティ種類
	 * @return	アクティビティ
	 */
	public ActivityState createElement(String activityKind)
	{
		if (activityKind == null) return null;

		if (activityKind.equals(ActivityElement.START)) {
			return new StartActivityState();
		} else if (activityKind.equals(ActivityElement.INTERACTIVE)) {
			return new InteractiveActivityState();
		} else if (activityKind.equals(ActivityElement.AUTOMATIC)) {
			return new AutomaticActivityState();
		} else if (activityKind.equals(ActivityElement.SUBPROCESS)) {
			return new SubprocessActivityState();
		} else if (activityKind.equals(ActivityElement.CONCUR_START)) {
			return new ConcurrentStartActivityState();
		} else if (activityKind.equals(ActivityElement.CONCUR_END)) {
			return new ConcurrentEndActivityState();
		} else if (activityKind.equals(ActivityElement.END)) {
			return new EndActivityState();
		} else {
			return null;
		}
	}

	/**
	 * パレット名からアクティビティ状態を返す。
	 * 
	 * @param paletteName	パレット名
	 * @return	アクティビティ状態
	 */
	public ActivityState createElementByPalette(String paletteName)
	{
		if (paletteName == null) return null;

		if (paletteName.equals(WorkflowDesignerConstants.PAL_INTERACTIVE)) {
			return new InteractiveActivityState();
		} else if (paletteName.equals(WorkflowDesignerConstants.PAL_AUTOMATIC)) {
			return new AutomaticActivityState();
		} else if (paletteName.equals(WorkflowDesignerConstants.PAL_SUBPROCESS)) {
			return new SubprocessActivityState();
		} else if (paletteName.equals(WorkflowDesignerConstants.PAL_END)) {
			return new EndActivityState();
		} else {
			return null;
		}
	}
}
