/* $Id: XPDLFileFilter.java,v 1.1 2007/10/19 08:19:36 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.xpdl;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * ワークフロー定義データ形式であるXPDLファイルをJFileChooserで
 * 選択するためのフィルタである。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class XPDLFileFilter extends FileFilter
{
	/** フィルタ対象の拡張子 */
	public static final String EXTENSION = "xpdl";
	/** 説明 */
	private String description;

	/**
	 * XPDL選択用のフィルターを定義する。
	 * 
	 * @param desc 説明
	 */
	public XPDLFileFilter(String desc)
	{
		description = desc;
	}
	
	/**
	 * 指定されたファイルを受け入れるかどうかを判定する。
	 *
	 * @param file ファイル
	 * @return 判定結果
	 */
	public boolean accept(File file)
	{
		if (file.isDirectory()) return true;

		String fileName = file.getName();
		int periodIndex = fileName.lastIndexOf('.');

		boolean accepted = false;

		if ((periodIndex > 0) && (periodIndex < (fileName.length() - 1))) {
			String extension = fileName.substring(periodIndex + 1).toLowerCase();
			if (extension.equals(EXTENSION)) accepted = true;
		}
		return accepted;
	}

	/**
	 * フィルタの説明を返す。
	 *
	 * @return 説明
	 */
	public String getDescription()
	{
		return description;
	}
}
