/* $Id: SimulatorDialog.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.expression.ConditionalVariable;

/**
 * シミュレーション用のダイアログを提供する。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class SimulatorDialog extends JDialog
{
	/** シリアルバージョンID */
	private static final long serialVersionUID = 1L;

	/** 未設定 */
	public static final int EVAL_END_OPTION = 0;
	/** 評価 */
	public static final int EVAL_OPTION = 1;
	/** 完了 */
	public static final int END_OPTION  = 2;

	/** ビュー内容 */
	private SimulatorView view;
	/** 選択結果 */
	private int result = EVAL_END_OPTION;

	/**
	 * 変数編集用のダイアログを生成する。
	 */
	SimulatorDialog()
	{
		super((Frame)null, true);
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		setTitle(rm.getResource("SimulatorDialog.title"));
		
		view = new SimulatorView();

		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView(view);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		JButton evalButton = new JButton(rm.getResource("JButton.label.evaluate"));
		evalButton.setActionCommand("EVALUATE_OPTION");
		evalButton.addActionListener(listener);
		getRootPane().setDefaultButton(evalButton);
		buttonPane.add(evalButton);

		JButton endButton = new JButton(rm.getResource("JButton.label.end"));
		endButton.addActionListener(listener);
		buttonPane.add(endButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();

		setLocationRelativeTo(null);
	}

	/**
	 * ダイアログを初期化する。
	 */
	private void init()
	{
		result = EVAL_END_OPTION;
		view.init();
	}

	/**
	 * 例外発生かどうかを返す。
	 * 
	 * @return	例外発生選択ならtrue
	 */	
	boolean isExceptionRaising()
	{
		return view.isExceptionRaising();
	}

	/**
	 * 変数一覧を返す。
	 * 
	 * @return	変数一覧
	 */	
	List<ConditionalVariable> getCurrentVariables()
	{
		return view.getCurrentVariables();
	}
	
	/**
	 * 変数一覧を設定する。
	 * 
	 * @param vars	変数一覧
	 */
	void setCurrentVariables(List<ConditionalVariable> vars)
	{
		init();
		view.setCurrentVariables(vars);
	}
	
	/**
	 * アクティビティを設定する。
	 * 
	 * @param act	アクティビティ
	 */
	void setCurrentActivity(ActivityElement act)
	{
		init();
		view.setCurrentActivity(act);
	}

	/**
	 * 値編集の可否を設定する。
	 * 
	 * @param b	編集可否
	 */	
	void setValueEditable(boolean b)
	{
		view.setValueEditable(b);
	}
	
	/**
	 * ダイアログを閉じたときの結果を返す。
	 * 
	 * @return	結果
	 */
	int getResult()
	{
		return result;
	}

	/**
	 * ダイアログが閉じるときの処理
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * 押されたボタンに応じて結果を切り替える。
		 * 
		 * @param e	イベント
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if ("EVALUATE_OPTION".equals(e.getActionCommand())) {
				result = EVAL_OPTION;
			} else {
				result = END_OPTION;
			}
			setVisible(false);
		}
	}
}
