/* $Id: SimulatableActivityWrapper.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.util.EmptyStackException;
import java.util.Stack;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;

/**
 * アクティビティインスタンスをシミュレートするための
 * 擬似ラッパー。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public class SimulatableActivityWrapper
{
	/** アクティビティ */
	private ActivityElement act;
	/** 入力遷移 */
	private TransitionElement tr;
	/** ブロックスタック */
	private Stack<SimulatableActivityWrapper> blockStack =
		new Stack<SimulatableActivityWrapper>();
	
	/**
	 * 擬似ラッパーを生成する。
	 * 
	 * @param act	アクティビティ
	 * @param tr	入力遷移
	 */
	public SimulatableActivityWrapper(ActivityElement act, TransitionElement tr)
	{
		this.act = act;
		this.tr = tr;
		if (act.getType().equals(ActivityElement.CONCUR_START)) {
			blockStack.push(this);
		} else if (act.getType().equals(ActivityElement.CONCUR_END)) {
			blockStack.pop();
		}
	}

	/**
	 * 擬似ラッパーを生成する。
	 * 
	 * @param act	アクティビティ
	 * @param tr	入力遷移
	 * @param st	以前のスタック情報
	 */	
	public SimulatableActivityWrapper(ActivityElement act, TransitionElement tr, Stack<SimulatableActivityWrapper> st)
	{
		this.act = act;
		this.tr = tr;
		if (st != null) blockStack.addAll(st);
		if (act.getType().equals(ActivityElement.CONCUR_START)) {
			blockStack.push(this);
		} else if (act.getType().equals(ActivityElement.CONCUR_END)) {
			blockStack.pop();
		}
	}

	/**
	 * アクティビティを返す。
	 * 
	 * @return	アクティビティ
	 */	
	public ActivityElement getActivity()
	{
		return act;
	}

	/**
	 * 遷移を返す。
	 * 
	 * @return	遷移
	 */	
	public TransitionElement getTransition()
	{
		return tr;
	}

	/**
	 * ブロックスタックを返す。
	 * 
	 * @return	ブロックスタック
	 */	
	public Stack<SimulatableActivityWrapper> getBlockStack()
	{
		return blockStack;
	}

	/**
	 * ブロックスタックの最上位の要素を返す。
	 * 
	 * @return	ブロックアクティビティラッパー
	 */	
	public SimulatableActivityWrapper peekTopBlockWrapper()
	{
		try {
			return (SimulatableActivityWrapper)blockStack.peek();
		} catch (EmptyStackException ex) {
			return null;
		}
	}

	/**
	 * 指定されたブロックアクティビティラッパーを持つかどうかを返す。
	 * 
	 * @param wrapper	ブロックアクティビティラッパー
	 * @return	持つ場合にはtrue
	 */	
	public int searchBlockWrapper(SimulatableActivityWrapper wrapper)
	{
		return blockStack.search(wrapper);
	}
}
