/* $Id: PrintManager.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2004.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

import jp.co.argo21.nautica.commons.swing.DialogUtilities;
import jp.co.argo21.nautica.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;

/**
 * 印刷処理を行う。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public final class PrintManager
{
	/** 印刷マネージャ */
	private static PrintManager singleton = null;

	/** 印刷要求属性 */
	private PrintRequestAttributeSet aset;

	/**
	 * 印刷マネージャを生成する。
	 */
	private PrintManager()
	{
		/* 印刷要求の指定 */
		aset = new HashPrintRequestAttributeSet();
		aset.add(OrientationRequested.PORTRAIT);
		aset.add(MediaSizeName.ISO_A4);
		aset.add(new Copies(1));
		aset.add(new JobName("WorkflowDesigner", null));
	}

	/**
	 * 印刷マネージャを返す。
	 *
	 * @return 印刷マネージャ
	 */
	public static PrintManager getInstance()
	{
		if (singleton == null) {
			singleton = new PrintManager();
		}

		return singleton;
	}

	/**
	 * 保持しているインスタンスを解放する。
	 */
	public static void releaseInstance()
	{
		singleton = null;
	}

	/**
	 * 印刷要求属性を返す。
	 * 
	 * @return 印刷要求属性
	 */
	public PrintRequestAttributeSet getCurrentPageFormat()
	{
		return aset;
	}

	/**
	 * 印刷処理を呼び出し、指定された印刷対象の印刷を行う。
	 *
	 * @param data 印刷ドキュメント
	 */
	public void print(PrintData data)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		
		if (data == null) {
			DialogUtilities.showError(rm.getResource("message.error.0001"));
			return;
		}
		/* 印刷ジョブの作成 */
		PrinterJob job = PrinterJob.getPrinterJob();
		job.setPageable(data);

		/* 要求を受付可能な印刷サービス一覧を返す */
		PrintService[] services = PrinterJob.lookupPrintServices();

		if (services.length > 0) {
			try {
				/* ジョブに最初のプリンタを割り当てる */
				job.setPrintService(services[0]);
				/* ページ設定ダイアログの表示 */
				PageFormat format = job.pageDialog(aset);
				if (format == null) return;
				data.setFormat(format);
				/* 印刷ダイアログの表示 */
				if (job.printDialog(aset)) {
					// 印刷パネルの終了コードが真なら、印刷処理を実行
					job.print(aset);
				}
			} catch (PrinterException ex) {
				DialogUtilities.showError(rm.getResource("message.error.0002"));
			}
		} else {
			DialogUtilities.showError(rm.getResource("message.error.0003"));
		}
	}
}
