/* $Id: MappedParam.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

/**
 * 仮パラメータと実パラメータのマッピングを管理する。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
class MappedParam
{
	/** 仮パラメータ */
	private ParameterElement param;
	/** 実パラメータ */
	private VariableElement actualParam;
	
	/**
	 * マッピングを生成する。
	 * 
	 * @param p	仮パラメータ
	 */
	MappedParam(ParameterElement p)
	{
		param = p;
	}
	
	/**
	 * 実パラメータを返す。
	 * 
	 * @return	実パラメータ
	 */
	public VariableElement getActualParam()
	{
		return actualParam;
	}

	/**
	 * 仮パラメータを返す。
	 * 
	 * @return	仮パラメータ
	 */
	public ParameterElement getParam()
	{
		return param;
	}

	/**
	 * 実パラメータを設定する。
	 * 
	 * @param element	実パラメータ
	 */
	void setActualParam(VariableElement element)
	{
		actualParam = element;
	}
}
