/* $Id: AbstractElementInspector.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JTabbedPane;

import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * 要素用インスペクタのための抽象クラス
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public abstract class AbstractElementInspector extends JTabbedPane implements Inspector
{
	/** リスナー */
	private List<ChangeElementListener> listeners = new ArrayList<ChangeElementListener>();

	/** 対象要素 */
	private Element inspectable;

	/**
	 * 対象要素を返す。
	 * 
	 * @return	要素
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#getInspectable()
	 */
	public Element getInspectable()
	{
		return inspectable;
	}
	
	/**
	 * インスペクト対象を設定する。
	 * 
	 * @param elem	対象要素
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public void setInspectable(Element elem)
	{
		inspectable = elem;
	}

	/**
	 * インスペクタが自動コミットするかどうかを返す。
	 * 
	 * @return	自動コミットの場合にはtrue
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#isAutoCommit()
	 */
	public boolean isAutoCommit()
	{
		return false;
	}

	/**
	 * リスナーを追加する。
	 * 
	 * @param l リスナー
	 */
	public void addChangeElementListener(ChangeElementListener l)
	{
		if (listeners.contains(l) == false) listeners.add(l);
	}

	/**
	 * リスナーを削除する。
	 * 
	 * @param l リスナー
	 */
	public void removeChangeElementListener(ChangeElementListener l)
	{
		if (listeners.contains(l)) listeners.remove(l);
	}

	/**
	 * リスナーに要素の変更を同報する。
	 */
	protected void fireElementChanged()
	{
		for (ChangeElementListener l : listeners) {
			l.elementChanged(inspectable);
		}
	}

	/**
	 * インスペクタを初期化する。
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		//NOP
	}

	/**
	 * インスペクタのアンロードを行う。
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#unload()
	 */
	public void unload()
	{
		//NOP
	}
}
