/* $Id: ExceptionExpression.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.expression;

import java.util.List;

import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

import org.apache.xmlbeans.XmlObject;

/**
 * EXCEPTION条件式
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public class ExceptionExpression implements Expression
{
	/** EXCEPTION */
	private static final String EXCEPTION_STR = "EXCEPTION";
	
	/**
	 * EXCEPTION条件式を生成する。
	 */
	public ExceptionExpression()
	{
	}

	/**
	 * 引数のオブジェクトに条件式を格納する。
	 * 
	 * @param o	XMLオブジェクト
	 * @see jp.co.argo21.nautica.tool.wfd.expression.Expression#saveTo(org.apache.xmlbeans.XmlObject)
	 */	
	public void saveTo(XmlObject o)
	{
	}

	/**
	 * 引数の情報を元に条件を評価する。
	 * 
	 * @param list	変数の現在値
	 * @return	条件が満たされた場合はtrue
	 * @see jp.co.argo21.nautica.tool.wfd.expression.Expression#eval(java.util.List)
	 */
	public boolean eval(List<ConditionalVariable> list)
	{
		return false;
	}

	/**
	 * 条件式の文字列表現を返す。
	 * 
	 * @return	文字列表現
	 * @see jp.co.argo21.nautica.tool.wfd.expression.Expression#getExpressionString()
	 */
	public String getExpressionString()
	{
		return EXCEPTION_STR;
	}

	/**
	 * 変数一覧を利用しながら条件式の文字列表現を返す。
	 * 
	 * @param vars	変数一覧
	 * @return	文字列表現
	 * @see jp.co.argo21.nautica.tool.wfd.expression.Expression#getExpressionString(java.util.List)
	 */
	public String getExpressionString(List<VariableElement> vars)
	{
		return getExpressionString();
	}

	/**
	 * この条件式に含まれるすべての条件式を返す。
	 * 
	 * @param exps	条件式一覧
	 * @see jp.co.argo21.nautica.tool.wfd.expression.Expression#getAllExpressions(java.util.List)
	 */
	public void getAllExpressions(List<Expression> exps)
	{
	}
}
