/* $Id: TransitionElement.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import jp.co.argo21.nautica.tool.wfd.expression.Expression;

import org.wfmc.x2002.xpdl10.ConditionDocument;

/**
 * 遷移定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface TransitionElement extends Element
{
	/** 遷移ID接頭辞 */
	public static final String ID_PREFIX  = "TR";

	/** 条件 */
	public static final int CONDITION        = ConditionDocument.Condition.Type.INT_CONDITION;
	/** その他 */
	public static final int OTHERWISE        = ConditionDocument.Condition.Type.INT_OTHERWISE;
	/** 例外 */
	public static final int EXCEPTION        = ConditionDocument.Condition.Type.INT_EXCEPTION;
	/** デフォルト例外 */
	public static final int DEFAULTEXCEPTION = ConditionDocument.Condition.Type.INT_DEFAULTEXCEPTION;

	/**
	 * 遷移元アクティビティを返す。
	 * 
	 * @return	遷移元アクティビティ
	 */
	public ActivityElement getSource();

	/**
	 * 遷移先アクティビティを返す。
	 * 
	 * @return	遷移先アクティビティ
	 */
	public ActivityElement getDestination();

	/**
	 * 遷移条件を返す。
	 * 
	 * @return	遷移条件
	 */
	public Expression getCondition();

	/**
	 * 遷移型を返す。
	 * 
	 * @return	遷移型
	 */
	public int getType();

	/**
	 * 遷移条件を設定する。
	 * 
	 * @param cond	遷移条件
	 */	
	public void setCondition(Expression cond);

	/**
	 * 遷移型を設定する。
	 * 
	 * @param type	遷移型
	 */
	public void setType(int type);	
}
