/* $Id: Element.java,v 1.1 2007/10/19 08:19:34 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import jp.co.argo21.nautica.commons.util.ResourceManager;

/**
 * すべての要素の基底インタフェースである。
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.1 $
 * @since   Nautica Workflow 1.0
 */
public interface Element
{
	/**
	 * IDを返す。
	 * 
	 * @return ID
	 */
	public String getID();
	
	/**
	 * 名称を返す。
	 * 
	 * @return 名称
	 */
	public String getName();
	
	/**
	 * 説明を返す。
	 */
	public String getDescription();
	
	/**
	 * ツールボックス文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 */
	public String getTooltipText(ResourceManager rm);
	
	/**
	 * 印刷用文字列を返す。
	 * 
	 * @param rm	リソースマネージャ
	 * @return	文字列
	 */
	public String getPrintText(ResourceManager rm);

	/**
	 * 名称を設定する。
	 * 
	 * @param name 名称
	 */
	public void setName(String name);
	
	/**
	 * 
	 * 
	 * @param desc
	 */
	public void setDescription(String desc);
	
	/**
	 * 指定された要素を使用中かどうかを返す。
	 *
	 * @param elem 要素
	 * @return 使用中ならtrue
	 */
	public boolean isUsed(Element elem);
}
