/* $Id: ActivityElement.java,v 1.2 2007/12/11 09:54:58 nito Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005, 2006.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import java.util.List;

import org.wfmc.x2002.xpdl10.SubFlowDocument;

/**
 * アクティビティ定義用インタフェース
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.2 $
 * @since   Nautica Workflow 1.0
 */
public interface ActivityElement extends Element
{
	/** アクティビティID用接頭辞 */
	public static final String ID_PREFIX       = "AC";
	/** ブロックID用接頭辞 */
	public static final String BLOCK_ID_PREFIX = "BK";

	/** アクティビティ型取得キー */
	public static final String ACTIVITY_TYPE = "ACTIVITY_TYPE";
	/** 論理X座標取得キー */
	public static final String LOGICAL_X     = "LOGICAL_X";
	/** 論理Y座標取得キー */
	public static final String LOGICAL_Y     = "LOGICAL_Y";
	/** 所属ブロックID取得キー */
	public static final String AFFILIATE_BID = "AFFILIATE_BID";
	/** 親ブロックID取得キー */
	public static final String PARENT_BID    = "PARENT_BID";
	/** エンジン名 */
	public static final String ENGINE_NANE   = "ENGINE_NANE";

	/** 開始アクティビティ型 */
	public static final String START        = "START";
	/** 対話型アクティビティ型 */
	public static final String INTERACTIVE  = "INTERACTIVE";
	/** 自動実行アクティビティ型 */
	public static final String AUTOMATIC    = "AUTOMATIC";
	/** サブプロセスアクティビティ型 */
	public static final String SUBPROCESS   = "SUBPROCESS";
	/** 並行処理アクティビティ型 */
	public static final String CONCURRENT   = "CONCURRENT";
	/** 並行処理開始アクティビティ型 */
	public static final String CONCUR_START = "CONCUR_START";
	/** 並行処理終了アクティビティ型 */
	public static final String CONCUR_END   = "CONCUR_END";
	/** 終了アクティビティ型 */
	public static final String END          = "END";

	/** 非同期 */
	public static final int ASYNCHR = SubFlowDocument.SubFlow.Execution.INT_ASYNCHR;
	/** 同期 */
	public static final int SYNCHR  = SubFlowDocument.SubFlow.Execution.INT_SYNCHR;

	/**
	 * アクティビティ型を返す。
	 * 
	 * @return	アクティビティ型
	 */
	public String getType();

	/**
	 * 実行期限を返す。
	 * 
	 * @return	実行期限
	 */
	public int getLimit();

	/**
	 * 論理X座標を返す。
	 * 
	 * @return	論理X座標
	 */
	public int getLogicalX();

	/**
	 * 論理Y座標を返す。
	 * 
	 * @return	論理Y座標
	 */
	public int getLogicalY();

	/**
	 * ブロックIDを返す。
	 * 
	 * @return	ブロックID
	 */
	public String getBlockID();

	/**
	 * 所属ブロックIDを返す。
	 * 
	 * @return	所属ブロックID
	 */
	public String getAffiliateBID();

	/**
	 * 親ブロックIDを返す。
	 * 
	 * @return	親ブロックID
	 */
	public String getParentBID();

	/**
	 * サブプロセス実行時の同期状態を返す。
	 * 
	 * @return	サブプロセス実行時の同期状態
	 */
	public int getExecution();

	/**
	 * アクティビティ状態を返す。
	 * 
	 * @return	アクティビティ状態
	 */
	public ActivityState getActivityState();

	/**
	 * アプリケーションIDを返す。
	 * 
	 * @return	アプリケーションID
	 */
	public String getApplicationID();

	/**
	 * サブプロセスIDを返す。
	 * 
	 * @return	サブプロセスID
	 */
	public String getSubprocessID();

	/**
	 * 実行許可者IDを返す。
	 * 
	 * @return	実行許可者ID
	 */
	public String getPerformerID();

	/**
	 * アプリケーションパラメータ一覧を返す。
	 * 
	 * @return	アプリケーションパラメータ一覧
	 */
	public List<String> getApplicationParameters();

	/**
	 * サブプロセスパラメータ一覧を返す。
	 * 
	 * @return	サブプロセスパラメータ一覧
	 */
	public List<String> getSubprocessParameters();

	/**
	 * エンジン名を返す。
	 * 
	 * @return	エンジン名
	 */
	public String getEngineName();

	/**
	 * 実行期限を設定する。
	 * 
	 * @param limit	実行期限
	 */
	public void setLimit(int limit);

	/**
	 * 論理X座標を設定する。
	 * 
	 * @param x	論理X座標
	 */
	public void setLogicalX(int x);
	
	/**
	 * 論理Y座標を設定する。
	 * 
	 * @param y	論理Y座標
	 */
	public void setLogicalY(int y);
	
	/**
	 * ブロックIDを設定する。
	 * 
	 * @param id	ブロックID
	 */
	public void setBlockID(String id);
	
	/**
	 * 所属ブロックIDを設定する。
	 * 
	 * @param id	所属ブロックID
	 */
	public void setAffiliateBID(String id);
	
	/**
	 * 親ブロックIDを設定する。
	 * 
	 * @param id	親ブロックID
	 */
	public void setParentBID(String id);
	
	/**
	 * サブプロセス実行時の同期状態を設定する。
	 * 
	 * @param sync	サブプロセス実行時の同期状態
	 */
	public void setExecution(int sync);
	
	/**
	 * 実行許可者IDを設定する。
	 * 
	 * @param id	実行許可者ID
	 */
	public void setPerformerID(String id);
	
	/**
	 * アプリケーションIDを設定する。
	 * 
	 * @param id	アプリケーションID
	 */
	public void setApplicationID(String id);
	
	/**
	 * サブプロセスIDを設定する。
	 * 
	 * @param id	サブプロセスID
	 */
	public void setSubprocessID(String id);
	
	/**
	 * エンジン名を設定する。
	 * 
	 * @param engineName	エンジン名
	 */
	public void setEngineName(String engineName);

	/**
	 * アプリケーションパラメータを追加する。
	 * 
	 * @param id	アプリケーションパラメータ
	 */
	public void addApplicationParameterID(String id);
	
	/**
	 * サブプロセスパラメータを追加する。
	 * 
	 * @param id	サブプロセスパラメータ
	 */
	public void addSubprocessParameterID(String id);

	/**
	 * アプリケーションパラメータを削除する。
	 * 
	 * @param id	アプリケーションパラメータ
	 */
	public void removeApplicationParameterID(String id);
	
	/**
	 * サブプロセスパラメータを削除する。
	 * 
	 * @param id	サブプロセスパラメータ
	 */
	public void removeSubprocessParameterID(String id);

	/**
	 * 複製する。
	 * 
	 * @return	複製したアクティビティ
	 */	
	public ActivityElement copy();
}
